% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_groups.R
\name{check_groups}
\alias{check_groups}
\title{Check group specification}
\usage{
check_groups(groups, all_features)
}
\arguments{
\item{groups}{(\code{list}) A (named) list of groups}

\item{all_features}{(character()) All available feature names from the task.}
}
\value{
The input list \code{group}, with each element now named.
}
\description{
Check group specification
}
\examples{
task <- sim_dgp_interactions(n = 100)
task$feature_names

# Intended use
groups1 = list(effects = c("x1", "x2", "x3"), noise = c("noise1", "noise2"))
check_groups(groups1, task$feature_names)

# Names are auto-generated where needed
check_groups(list(a = "x1",  c("x2", "x1")), task$feature_names)

# Examples for cases that throw errors:

# Unexpected features
groups2 = list(effects = c("x1", "foo", "bar", "x1"))
try(check_groups(groups2, task$feature_names))
# Too deeply nested
groups3 = list(effects = c("x1", "x2", "x3"), noise = c("noise1", list(c("noise2"))))
try(check_groups(groups2, task$feature_names))

}
\concept{utilities}
