% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-opt.R
\name{xplain_opt}
\alias{xplain_opt}
\title{xplainfi Package Options}
\usage{
xplain_opt(...)
}
\arguments{
\item{...}{Option names to retrieve (as character strings) or options to set (as named arguments).
\itemize{
\item To \strong{get} an option: \code{xplain_opt("verbose")} returns the current value
\item To \strong{set} an option: \code{xplain_opt(verbose = FALSE)} sets the value
\item To \strong{get all} options: \code{xplain_opt()} returns a named list of all options
}}
}
\value{
\itemize{
\item When \strong{getting} a single option: the option value (logical)
\item When \strong{getting} multiple options: a named list of option values
\item When \strong{setting} options: the previous values (invisibly)
}
}
\description{
Get or set package-level options for xplainfi.
}
\details{
Options can be set in three ways (in order of precedence):
\enumerate{
\item Using \code{xplain_opt(option_name = value)} (recommended)
\item Using \code{options("xplain.option_name" = value)}
\item Using environment variables \code{XPLAIN_OPTION_NAME=value}
}
\subsection{Available Options}{\tabular{lll}{
   Option \tab Default \tab Description \cr
   \code{verbose} \tab \code{TRUE} \tab Show informational messages (e.g., when using default measure or resampling) \cr
   \code{progress} \tab \code{FALSE} \tab Show progress bars during computation \cr
   \code{sequential} \tab \code{FALSE} \tab Force sequential execution (disable parallelization) \cr
   \code{debug} \tab \code{FALSE} \tab Enable debug output for development and troubleshooting \cr
}

}
}
\examples{
# Get current value of an option
xplain_opt("verbose")

# Get all options
xplain_opt()

# Set an option (returns previous value invisibly)
old <- xplain_opt(verbose = FALSE)
xplain_opt("verbose")  # Now FALSE

# Restore previous value
xplain_opt(verbose = old$verbose)

# Temporary option change with withr
if (requireNamespace("withr", quietly = TRUE)) {
  withr::with_options(
    list("xplain.verbose" = FALSE),
    {
      # Code here runs with verbose = FALSE
      xplain_opt("verbose")
    }
  )
}

}
