% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xsubset.R
\name{xsubset}
\alias{xsubset}
\alias{xsubset<-}
\title{Extract or set the value of the Subset slot.}
\usage{
xsubset(object)

xsubset(object) <- value
}
\arguments{
\item{object}{An "xpose.data" object.}

\item{value}{A string with the subset expression.}
}
\value{
A string representing the subset expression.
}
\description{
Extract or set the value of the Subset slot of an "xpose.data" object.
}
\details{
The subset string has the same syntax as the subset argument to, e.g.
\code{panel.xyplot}. Note, however, that the "xpose.data" subset is not used
as an argument to \code{panel.xyplot}. It is intended as the subset argument
to the \code{Data} and \code{SData} functions.
}
\section{Functions}{
\itemize{
\item \code{xsubset(object) <- value}: assign value with a string representing the subset expression

}}
\examples{
xpdb <- simpraz.xpdb
xsubset(xpdb) <- "DV > 0"
xsubset(xpdb)

}
\seealso{
\code{\link{Data}}, \code{\link{SData}}

Other data functions: 
\code{\link{add_transformed_columns}},
\code{\link{change_graphical_parameters}},
\code{\link{change_misc_parameters}},
\code{\link{compute.cwres}()},
\code{\link{data.checkout}()},
\code{\link{data_extract_or_assign}},
\code{\link{db.names}()},
\code{\link{export.graph.par}()},
\code{\link{export.variable.definitions}()},
\code{\link{import.graph.par}()},
\code{\link{import.variable.definitions}()},
\code{\link{make.sb.data}()},
\code{\link{nsim}()},
\code{\link{par_cov_summary}},
\code{\link{read.TTE.sim.data}()},
\code{\link{read.nm.tables}()},
\code{\link{read_NM_output}},
\code{\link{read_nm_table}()},
\code{\link{simprazExample}()},
\code{\link{tabulate.parameters}()},
\code{\link{xlabel}()},
\code{\link{xpose.data}},
\code{\link{xpose.print}()},
\code{\link{xpose4-package}}
}
\author{
Niclas Jonsson
}
\concept{data functions}
\keyword{methods}
