

/*
Refs:
- RISC-V Instruction Set Manual
  Machine Status (mstatus and mstatush) Registers
  https://github.com/riscv/riscv-isa-manual/blob/riscv-isa-release-8b9dc50-2024-08-30/src/machine.adoc#machine-status-mstatus-and-mstatush-registers
  Supervisor Status (sstatus) Register
  https://github.com/riscv/riscv-isa-manual/blob/riscv-isa-release-8b9dc50-2024-08-30/src/supervisor.adoc#supervisor-status-sstatus-register

See also src/imp/riscv.rs.

Generated asm:
- riscv64gc https:
*/

#[cfg(not(portable_atomic_no_asm))]
use core::arch::asm;

pub(super) use super::super::riscv as atomic;


#[cfg(not(portable_atomic_s_mode))]
macro_rules! status {
    () => {
        "mstatus"
    };
}
#[cfg(portable_atomic_s_mode)]
macro_rules! status {
    () => {
        "sstatus"
    };
}


#[cfg(not(portable_atomic_s_mode))]
const MASK: State = 0x8;
#[cfg(not(portable_atomic_s_mode))]
macro_rules! mask {
    () => {
        "0x8"
    };
}

#[cfg(portable_atomic_s_mode)]
const MASK: State = 0x2;
#[cfg(portable_atomic_s_mode)]
macro_rules! mask {
    () => {
        "0x2"
    };
}

#[cfg(target_arch = "riscv32")]
pub(super) type State = u32;
#[cfg(target_arch = "riscv64")]
pub(super) type State = u64;


#[inline(always)]
pub(super) fn disable() -> State {
    let status: State;
    
    
    unsafe {
        
        asm!(
            concat!("csrrci {status}, ", status!(), ", ", mask!()), 
            status = out(reg) status,
            options(nostack, preserves_flags),
        );
    }
    status
}



/// # Safety


#[inline(always)]
pub(super) unsafe fn restore(status: State) {
    if status & MASK != 0 {
        
        
        unsafe {
            
            asm!(
                concat!("csrsi ", status!(), ", ", mask!()), 
                options(nostack, preserves_flags),
            );
        }
    }
}
