



































//! # Example


//! procedural macro having to do with data structure serialization. The `#var`








//! # use quote::quote;
//! #
//! # let generics = "";
//! # let where_clause = "";
//! # let field_ty = "";
//! # let item_ty = "";
//! # let path = "";
//! # let value = "";
//! #

//!     struct SerializeWith #generics #where_clause {
//!         value: &'a #field_ty,
//!         phantom: core::marker::PhantomData<#item_ty>,


//!     impl #generics serde::Serialize for SerializeWith #generics #where_clause {




//!             #path(self.value, serializer)




//!         value: #value,
//!         phantom: core::marker::PhantomData::<#item_ty>,






//! # Non-macro code generators









#![doc(html_root_url = "https://docs.rs/quote/1.0.40")]
#![allow(
    clippy::doc_markdown,
    clippy::elidable_lifetime_names,
    clippy::missing_errors_doc,
    clippy::missing_panics_doc,
    clippy::module_name_repetitions,
    clippy::needless_lifetimes,
    
    clippy::wrong_self_convention,
)]

extern crate alloc;

#[cfg(feature = "proc-macro")]
extern crate proc_macro;

mod ext;
mod format;
mod ident_fragment;
mod to_tokens;


#[doc(hidden)]
#[path = "runtime.rs"]
pub mod __private;

pub use crate::ext::TokenStreamExt;
pub use crate::ident_fragment::IdentFragment;
pub use crate::to_tokens::ToTokens;


#[doc(hidden)]
pub mod spanned;

macro_rules! __quote {
    ($quote:item) => {
        
        
        
        
        
        
        
        
        
        
        /// # Interpolation
        
        /// Variable interpolation is done with `#var` (similar to `$var` in
        
        
        
        
        
        
        
        
        /// Repetition is done using `#(...)*` or `#(...),*` again similar to
        
        
        
        
        
        /// - `#(#var)*` — no separators
        /// - `#(#var),*` — the character before the asterisk is used as a separator
        /// - `#( struct #var; )*` — the repetition can contain other tokens
        /// - `#( #k => println!("{}", #v), )*` — even multiple interpolations
        
        
        
        /// # Hygiene
        
        
        
        
        
        
        
        
        
        
        
        /// # Return type
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        /// # Examples
        
        /// ### Procedural macro
        
        
        
        
        
        
        
        
        /// # #[cfg(any())]
        
        /// # extern crate proc_macro2;
        
        /// # #[cfg(any())]
        
        /// # use proc_macro2::TokenStream;
        
        
        /// # const IGNORE_TOKENS: &'static str = stringify! {
        /// #[proc_macro_derive(HeapSize)]
        /// # };
        
        
        ///     # const IGNORE_TOKENS: &'static str = stringify! {
        
        
        ///     # };
        ///     #
        ///     # let name = 0;
        ///     # let expr = 0;
        
        
        
        ///         impl heapsize::HeapSize for #name {
        
        ///                 #expr
        
        
        
        
        
        
        
        
        
        
        
        /// ### Combining quoted fragments
        
        
        
        
        
        
        
        /// # use quote::quote;
        /// #
        
        
        
        
        ///     #type_definition
        ///     #methods
        
        
        
        
        
        /// ### Constructing identifiers
        
        
        
        
        
        
        
        
        
        
        /// # use proc_macro2::{self as syn, Span};
        /// # use quote::quote;
        /// #
        /// # let ident = syn::Ident::new("i", Span::call_site());
        /// #
        
        
        ///     let mut _#ident = 0;
        
        /// # ;
        
        
        
        
        
        
        
        /// # use proc_macro2::{Ident, Span};
        /// # use quote::{format_ident, quote};
        /// #
        /// # let ident = Ident::new("i", Span::call_site());
        /// #
        
        
        ///     let mut #varname = 0;
        
        /// # ;
        
        
        
        
        
        
        
        /// # use proc_macro2::{self as syn, Span};
        /// # use quote::quote;
        /// #
        /// # let ident = syn::Ident::new("i", Span::call_site());
        /// #
        
        
        
        ///     let mut #varname = 0;
        
        /// # ;
        
        
        
        
        /// ### Making method calls
        
        
        
        
        
        
        /// # use quote::quote;
        /// #
        /// # let field_type = quote!(...);
        /// #
        
        
        ///     let value = #field_type::new();
        
        /// # ;
        
        
        
        
        
        
        
        
        
        /// # use quote::quote;
        /// #
        /// # let field_type = quote!(...);
        /// #
        
        ///     let value = <#field_type>::new();
        
        /// # ;
        
        
        
        
        
        
        
        /// # use quote::quote;
        /// #
        /// # let field_type = quote!(...);
        /// #
        
        ///     let value = <#field_type as core::default::Default>::default();
        
        /// # ;
        
        
        
        
        /// ### Interpolating text inside of doc comments
        
        
        
        
        
        
        ///     /// try to interpolate: #ident
        
        
        
        
        
        
        
        ///     #[doc = "try to interpolate: #ident"]
        
        
        
        
        
        
        
        /// # use proc_macro2::{Ident, Span};
        /// # use quote::quote;
        /// #
        /// # const IGNORE: &str = stringify! {
        
        /// # };
        /// #
        /// # let ident = Ident::new("var", Span::call_site());
        /// # let msg = format!("try to interpolate: {}", ident);
        
        ///     #[doc = #msg]
        
        
        
        /// # ;
        
        
        
        
        /// ### Indexing into a tuple struct
        
        
        
        
        
        
        
        
        
        
        
        
        
        ///     0 #( + self.#i.heap_size() )*
        
        
        
        
        /// # use proc_macro2::{Ident, TokenStream};
        /// # use quote::quote;
        /// #
        /// # mod syn {
        /// #     use proc_macro2::{Literal, TokenStream};
        /// #     use quote::{ToTokens, TokenStreamExt};
        /// #
        /// #     pub struct Index(usize);
        /// #
        /// #     impl From<usize> for Index {
        /// #         fn from(i: usize) -> Self {
        /// #             Index(i)
        /// #         }
        /// #     }
        /// #
        /// #     impl ToTokens for Index {
        /// #         fn to_tokens(&self, tokens: &mut TokenStream) {
        /// #             tokens.append(Literal::usize_unsuffixed(self.0));
        /// #         }
        /// #     }
        /// # }
        /// #
        /// # struct Struct {
        /// #     fields: Vec<Ident>,
        /// # }
        /// #
        /// # impl Struct {
        /// #     fn example(&self) -> TokenStream {
        
        
        
        
        ///     0 #( + self.#i.heap_size() )*
        
        /// #     }
        /// # }
        
        $quote
    };
}

#[cfg(doc)]
__quote![
    #[macro_export]
    macro_rules! quote {
        ($($tt:tt)*) => {
            ...
        };
    }
];

#[cfg(not(doc))]
__quote![
    #[macro_export]
    macro_rules! quote {
        () => {
            $crate::__private::TokenStream::new()
        };

        
        ($tt:tt) => {{
            let mut _s = $crate::__private::TokenStream::new();
            $crate::quote_token!{$tt _s}
            _s
        }};

        
        (# $var:ident) => {{
            let mut _s = $crate::__private::TokenStream::new();
            $crate::ToTokens::to_tokens(&$var, &mut _s);
            _s
        }};
        ($tt1:tt $tt2:tt) => {{
            let mut _s = $crate::__private::TokenStream::new();
            $crate::quote_token!{$tt1 _s}
            $crate::quote_token!{$tt2 _s}
            _s
        }};

        
        ($($tt:tt)*) => {{
            let mut _s = $crate::__private::TokenStream::new();
            $crate::quote_each_token!{_s $($tt)*}
            _s
        }};
    }
];

macro_rules! __quote_spanned {
    ($quote_spanned:item) => {
        
        
        
        
        
        /// # Syntax
        
        
        
        
        
        
        
        
        
        /// # use proc_macro2::Span;
        /// # use quote::quote_spanned;
        /// #
        /// # const IGNORE_TOKENS: &'static str = stringify! {
        
        /// # };
        /// # let span = Span::call_site();
        /// # let init = 0;
        
        
        /// let tokens = quote_spanned!(span=> Box::into_raw(Box::new(#init)));
        
        
        
        ///     Box::into_raw(Box::new(#init))
        
        
        
        
        
        
        
        
        
        
        
        /// # Hygiene
        
        
        
        
        
        
        
        /// # Example
        
        
        
        
        
        
        /// # use quote::{quote_spanned, TokenStreamExt, ToTokens};
        /// # use proc_macro2::{Span, TokenStream};
        /// #
        /// # struct Type;
        /// #
        /// # impl Type {
        /// #     fn span(&self) -> Span {
        /// #         Span::call_site()
        /// #     }
        /// # }
        /// #
        /// # impl ToTokens for Type {
        /// #     fn to_tokens(&self, _tokens: &mut TokenStream) {}
        /// # }
        /// #
        /// # let ty = Type;
        /// # let call_site = Span::call_site();
        /// #
        
        
        ///     struct _AssertSync where #ty: Sync;
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        $quote_spanned
    };
}

#[cfg(doc)]
__quote_spanned![
    #[macro_export]
    macro_rules! quote_spanned {
        ($span:expr=> $($tt:tt)*) => {
            ...
        };
    }
];

#[cfg(not(doc))]
__quote_spanned![
    #[macro_export]
    macro_rules! quote_spanned {
        ($span:expr=>) => {{
            let _: $crate::__private::Span = $crate::__private::get_span($span).__into_span();
            $crate::__private::TokenStream::new()
        }};

        
        ($span:expr=> $tt:tt) => {{
            let mut _s = $crate::__private::TokenStream::new();
            let _span: $crate::__private::Span = $crate::__private::get_span($span).__into_span();
            $crate::quote_token_spanned!{$tt _s _span}
            _s
        }};

        
        ($span:expr=> # $var:ident) => {{
            let mut _s = $crate::__private::TokenStream::new();
            let _: $crate::__private::Span = $crate::__private::get_span($span).__into_span();
            $crate::ToTokens::to_tokens(&$var, &mut _s);
            _s
        }};
        ($span:expr=> $tt1:tt $tt2:tt) => {{
            let mut _s = $crate::__private::TokenStream::new();
            let _span: $crate::__private::Span = $crate::__private::get_span($span).__into_span();
            $crate::quote_token_spanned!{$tt1 _s _span}
            $crate::quote_token_spanned!{$tt2 _s _span}
            _s
        }};

        
        ($span:expr=> $($tt:tt)*) => {{
            let mut _s = $crate::__private::TokenStream::new();
            let _span: $crate::__private::Span = $crate::__private::get_span($span).__into_span();
            $crate::quote_each_token_spanned!{_s _span $($tt)*}
            _s
        }};
    }
];

// Extract the names of all #metavariables and pass them to the $call macro.

// in:   pounded_var_names!(then!(...) a #b c #( #d )* #e)



#[macro_export]
#[doc(hidden)]
macro_rules! pounded_var_names {
    ($call:ident! $extra:tt $($tts:tt)*) => {
        $crate::pounded_var_names_with_context!{$call! $extra
            (@ $($tts)*)
            ($($tts)* @)
        }
    };
}

#[macro_export]
#[doc(hidden)]
macro_rules! pounded_var_names_with_context {
    ($call:ident! $extra:tt ($($b1:tt)*) ($($curr:tt)*)) => {
        $(
            $crate::pounded_var_with_context!{$call! $extra $b1 $curr}
        )*
    };
}

#[macro_export]
#[doc(hidden)]
macro_rules! pounded_var_with_context {
    ($call:ident! $extra:tt $b1:tt ( $($inner:tt)* )) => {
        $crate::pounded_var_names!{$call! $extra $($inner)*}
    };

    ($call:ident! $extra:tt $b1:tt [ $($inner:tt)* ]) => {
        $crate::pounded_var_names!{$call! $extra $($inner)*}
    };

    ($call:ident! $extra:tt $b1:tt { $($inner:tt)* }) => {
        $crate::pounded_var_names!{$call! $extra $($inner)*}
    };

    ($call:ident!($($extra:tt)*) # $var:ident) => {
        $crate::$call!($($extra)* $var);
    };

    ($call:ident! $extra:tt $b1:tt $curr:tt) => {};
}

#[macro_export]
#[doc(hidden)]
macro_rules! quote_bind_into_iter {
    ($has_iter:ident $var:ident) => {
        
        #[allow(unused_mut)]
        let (mut $var, i) = $var.quote_into_iter();
        let $has_iter = $has_iter | i;
    };
}

#[macro_export]
#[doc(hidden)]
macro_rules! quote_bind_next_or_break {
    ($var:ident) => {
        let $var = match $var.next() {
            Some(_x) => $crate::__private::RepInterp(_x),
            None => break,
        };
    };
}




















































// repetition with separator, as in `# (#var) , *`) to be fully represented with




//   - When it is a `#`, quote_token_with_context can do an interpolation. The











#[macro_export]
#[doc(hidden)]
macro_rules! quote_each_token {
    ($tokens:ident $($tts:tt)*) => {
        $crate::quote_tokens_with_context!{$tokens
            (@ @ @ @ @ @ $($tts)*)
            (@ @ @ @ @ $($tts)* @)
            (@ @ @ @ $($tts)* @ @)
            (@ @ @ $(($tts))* @ @ @)
            (@ @ $($tts)* @ @ @ @)
            (@ $($tts)* @ @ @ @ @)
            ($($tts)* @ @ @ @ @ @)
        }
    };
}


#[macro_export]
#[doc(hidden)]
macro_rules! quote_each_token_spanned {
    ($tokens:ident $span:ident $($tts:tt)*) => {
        $crate::quote_tokens_with_context_spanned!{$tokens $span
            (@ @ @ @ @ @ $($tts)*)
            (@ @ @ @ @ $($tts)* @)
            (@ @ @ @ $($tts)* @ @)
            (@ @ @ $(($tts))* @ @ @)
            (@ @ $($tts)* @ @ @ @)
            (@ $($tts)* @ @ @ @ @)
            ($($tts)* @ @ @ @ @ @)
        }
    };
}


#[macro_export]
#[doc(hidden)]
macro_rules! quote_tokens_with_context {
    ($tokens:ident
        ($($b3:tt)*) ($($b2:tt)*) ($($b1:tt)*)
        ($($curr:tt)*)
        ($($a1:tt)*) ($($a2:tt)*) ($($a3:tt)*)
    ) => {
        $(
            $crate::quote_token_with_context!{$tokens $b3 $b2 $b1 $curr $a1 $a2 $a3}
        )*
    };
}


#[macro_export]
#[doc(hidden)]
macro_rules! quote_tokens_with_context_spanned {
    ($tokens:ident $span:ident
        ($($b3:tt)*) ($($b2:tt)*) ($($b1:tt)*)
        ($($curr:tt)*)
        ($($a1:tt)*) ($($a2:tt)*) ($($a3:tt)*)
    ) => {
        $(
            $crate::quote_token_with_context_spanned!{$tokens $span $b3 $b2 $b1 $curr $a1 $a2 $a3}
        )*
    };
}


#[macro_export]
#[doc(hidden)]
macro_rules! quote_token_with_context {
    
    
    ($tokens:ident $b3:tt $b2:tt $b1:tt @ $a1:tt $a2:tt $a3:tt) => {};

    
    ($tokens:ident $b3:tt $b2:tt $b1:tt (#) ( $($inner:tt)* ) * $a3:tt) => {{
        use $crate::__private::ext::*;
        let has_iter = $crate::__private::ThereIsNoIteratorInRepetition;
        $crate::pounded_var_names!{quote_bind_into_iter!(has_iter) () $($inner)*}
        let _: $crate::__private::HasIterator = has_iter;
        
        
        
        
        
        
        while true {
            $crate::pounded_var_names!{quote_bind_next_or_break!() () $($inner)*}
            $crate::quote_each_token!{$tokens $($inner)*}
        }
    }};
    
    ($tokens:ident $b3:tt $b2:tt # (( $($inner:tt)* )) * $a2:tt $a3:tt) => {};
    
    ($tokens:ident $b3:tt # ( $($inner:tt)* ) (*) $a1:tt $a2:tt $a3:tt) => {};

    
    ($tokens:ident $b3:tt $b2:tt $b1:tt (#) ( $($inner:tt)* ) $sep:tt *) => {{
        use $crate::__private::ext::*;
        let mut _i = 0usize;
        let has_iter = $crate::__private::ThereIsNoIteratorInRepetition;
        $crate::pounded_var_names!{quote_bind_into_iter!(has_iter) () $($inner)*}
        let _: $crate::__private::HasIterator = has_iter;
        while true {
            $crate::pounded_var_names!{quote_bind_next_or_break!() () $($inner)*}
            if _i > 0 {
                $crate::quote_token!{$sep $tokens}
            }
            _i += 1;
            $crate::quote_each_token!{$tokens $($inner)*}
        }
    }};
    
    ($tokens:ident $b3:tt $b2:tt # (( $($inner:tt)* )) $sep:tt * $a3:tt) => {};
    
    ($tokens:ident $b3:tt # ( $($inner:tt)* ) ($sep:tt) * $a2:tt $a3:tt) => {};
    // (A special case for `#(var)**`, where the first `*` is treated as the
    
    ($tokens:ident # ( $($inner:tt)* ) * (*) $a1:tt $a2:tt $a3:tt) => {
        
        $crate::quote_token!{* $tokens}
    };
    
    ($tokens:ident # ( $($inner:tt)* ) $sep:tt (*) $a1:tt $a2:tt $a3:tt) => {};

    
    ($tokens:ident $b3:tt $b2:tt $b1:tt (#) $var:ident $a2:tt $a3:tt) => {
        $crate::ToTokens::to_tokens(&$var, &mut $tokens);
    };
    
    ($tokens:ident $b3:tt $b2:tt # ($var:ident) $a1:tt $a2:tt $a3:tt) => {};

    
    ($tokens:ident $b3:tt $b2:tt $b1:tt ($curr:tt) $a1:tt $a2:tt $a3:tt) => {
        $crate::quote_token!{$curr $tokens}
    };
}



#[macro_export]
#[doc(hidden)]
macro_rules! quote_token_with_context_spanned {
    ($tokens:ident $span:ident $b3:tt $b2:tt $b1:tt @ $a1:tt $a2:tt $a3:tt) => {};

    ($tokens:ident $span:ident $b3:tt $b2:tt $b1:tt (#) ( $($inner:tt)* ) * $a3:tt) => {{
        use $crate::__private::ext::*;
        let has_iter = $crate::__private::ThereIsNoIteratorInRepetition;
        $crate::pounded_var_names!{quote_bind_into_iter!(has_iter) () $($inner)*}
        let _: $crate::__private::HasIterator = has_iter;
        while true {
            $crate::pounded_var_names!{quote_bind_next_or_break!() () $($inner)*}
            $crate::quote_each_token_spanned!{$tokens $span $($inner)*}
        }
    }};
    ($tokens:ident $span:ident $b3:tt $b2:tt # (( $($inner:tt)* )) * $a2:tt $a3:tt) => {};
    ($tokens:ident $span:ident $b3:tt # ( $($inner:tt)* ) (*) $a1:tt $a2:tt $a3:tt) => {};

    ($tokens:ident $span:ident $b3:tt $b2:tt $b1:tt (#) ( $($inner:tt)* ) $sep:tt *) => {{
        use $crate::__private::ext::*;
        let mut _i = 0usize;
        let has_iter = $crate::__private::ThereIsNoIteratorInRepetition;
        $crate::pounded_var_names!{quote_bind_into_iter!(has_iter) () $($inner)*}
        let _: $crate::__private::HasIterator = has_iter;
        while true {
            $crate::pounded_var_names!{quote_bind_next_or_break!() () $($inner)*}
            if _i > 0 {
                $crate::quote_token_spanned!{$sep $tokens $span}
            }
            _i += 1;
            $crate::quote_each_token_spanned!{$tokens $span $($inner)*}
        }
    }};
    ($tokens:ident $span:ident $b3:tt $b2:tt # (( $($inner:tt)* )) $sep:tt * $a3:tt) => {};
    ($tokens:ident $span:ident $b3:tt # ( $($inner:tt)* ) ($sep:tt) * $a2:tt $a3:tt) => {};
    ($tokens:ident $span:ident # ( $($inner:tt)* ) * (*) $a1:tt $a2:tt $a3:tt) => {
        
        $crate::quote_token_spanned!{* $tokens $span}
    };
    ($tokens:ident $span:ident # ( $($inner:tt)* ) $sep:tt (*) $a1:tt $a2:tt $a3:tt) => {};

    ($tokens:ident $span:ident $b3:tt $b2:tt $b1:tt (#) $var:ident $a2:tt $a3:tt) => {
        $crate::ToTokens::to_tokens(&$var, &mut $tokens);
    };
    ($tokens:ident $span:ident $b3:tt $b2:tt # ($var:ident) $a1:tt $a2:tt $a3:tt) => {};

    ($tokens:ident $span:ident $b3:tt $b2:tt $b1:tt ($curr:tt) $a1:tt $a2:tt $a3:tt) => {
        $crate::quote_token_spanned!{$curr $tokens $span}
    };
}








#[macro_export]
#[doc(hidden)]
macro_rules! quote_token {
    ($ident:ident $tokens:ident) => {
        $crate::__private::push_ident(&mut $tokens, stringify!($ident));
    };

    (:: $tokens:ident) => {
        $crate::__private::push_colon2(&mut $tokens);
    };

    (( $($inner:tt)* ) $tokens:ident) => {
        $crate::__private::push_group(
            &mut $tokens,
            $crate::__private::Delimiter::Parenthesis,
            $crate::quote!($($inner)*),
        );
    };

    ([ $($inner:tt)* ] $tokens:ident) => {
        $crate::__private::push_group(
            &mut $tokens,
            $crate::__private::Delimiter::Bracket,
            $crate::quote!($($inner)*),
        );
    };

    ({ $($inner:tt)* } $tokens:ident) => {
        $crate::__private::push_group(
            &mut $tokens,
            $crate::__private::Delimiter::Brace,
            $crate::quote!($($inner)*),
        );
    };

    (# $tokens:ident) => {
        $crate::__private::push_pound(&mut $tokens);
    };

    (, $tokens:ident) => {
        $crate::__private::push_comma(&mut $tokens);
    };

    (. $tokens:ident) => {
        $crate::__private::push_dot(&mut $tokens);
    };

    (; $tokens:ident) => {
        $crate::__private::push_semi(&mut $tokens);
    };

    (: $tokens:ident) => {
        $crate::__private::push_colon(&mut $tokens);
    };

    (+ $tokens:ident) => {
        $crate::__private::push_add(&mut $tokens);
    };

    (+= $tokens:ident) => {
        $crate::__private::push_add_eq(&mut $tokens);
    };

    (& $tokens:ident) => {
        $crate::__private::push_and(&mut $tokens);
    };

    (&& $tokens:ident) => {
        $crate::__private::push_and_and(&mut $tokens);
    };

    (&= $tokens:ident) => {
        $crate::__private::push_and_eq(&mut $tokens);
    };

    (@ $tokens:ident) => {
        $crate::__private::push_at(&mut $tokens);
    };

    (! $tokens:ident) => {
        $crate::__private::push_bang(&mut $tokens);
    };

    (^ $tokens:ident) => {
        $crate::__private::push_caret(&mut $tokens);
    };

    (^= $tokens:ident) => {
        $crate::__private::push_caret_eq(&mut $tokens);
    };

    (/ $tokens:ident) => {
        $crate::__private::push_div(&mut $tokens);
    };

    (/= $tokens:ident) => {
        $crate::__private::push_div_eq(&mut $tokens);
    };

    (.. $tokens:ident) => {
        $crate::__private::push_dot2(&mut $tokens);
    };

    (... $tokens:ident) => {
        $crate::__private::push_dot3(&mut $tokens);
    };

    (..= $tokens:ident) => {
        $crate::__private::push_dot_dot_eq(&mut $tokens);
    };

    (= $tokens:ident) => {
        $crate::__private::push_eq(&mut $tokens);
    };

    (== $tokens:ident) => {
        $crate::__private::push_eq_eq(&mut $tokens);
    };

    (>= $tokens:ident) => {
        $crate::__private::push_ge(&mut $tokens);
    };

    (> $tokens:ident) => {
        $crate::__private::push_gt(&mut $tokens);
    };

    (<= $tokens:ident) => {
        $crate::__private::push_le(&mut $tokens);
    };

    (< $tokens:ident) => {
        $crate::__private::push_lt(&mut $tokens);
    };

    (*= $tokens:ident) => {
        $crate::__private::push_mul_eq(&mut $tokens);
    };

    (!= $tokens:ident) => {
        $crate::__private::push_ne(&mut $tokens);
    };

    (| $tokens:ident) => {
        $crate::__private::push_or(&mut $tokens);
    };

    (|= $tokens:ident) => {
        $crate::__private::push_or_eq(&mut $tokens);
    };

    (|| $tokens:ident) => {
        $crate::__private::push_or_or(&mut $tokens);
    };

    (? $tokens:ident) => {
        $crate::__private::push_question(&mut $tokens);
    };

    (-> $tokens:ident) => {
        $crate::__private::push_rarrow(&mut $tokens);
    };

    (<- $tokens:ident) => {
        $crate::__private::push_larrow(&mut $tokens);
    };

    (% $tokens:ident) => {
        $crate::__private::push_rem(&mut $tokens);
    };

    (%= $tokens:ident) => {
        $crate::__private::push_rem_eq(&mut $tokens);
    };

    (=> $tokens:ident) => {
        $crate::__private::push_fat_arrow(&mut $tokens);
    };

    (<< $tokens:ident) => {
        $crate::__private::push_shl(&mut $tokens);
    };

    (<<= $tokens:ident) => {
        $crate::__private::push_shl_eq(&mut $tokens);
    };

    (>> $tokens:ident) => {
        $crate::__private::push_shr(&mut $tokens);
    };

    (>>= $tokens:ident) => {
        $crate::__private::push_shr_eq(&mut $tokens);
    };

    (* $tokens:ident) => {
        $crate::__private::push_star(&mut $tokens);
    };

    (- $tokens:ident) => {
        $crate::__private::push_sub(&mut $tokens);
    };

    (-= $tokens:ident) => {
        $crate::__private::push_sub_eq(&mut $tokens);
    };

    ($lifetime:lifetime $tokens:ident) => {
        $crate::__private::push_lifetime(&mut $tokens, stringify!($lifetime));
    };

    (_ $tokens:ident) => {
        $crate::__private::push_underscore(&mut $tokens);
    };

    ($other:tt $tokens:ident) => {
        $crate::__private::parse(&mut $tokens, stringify!($other));
    };
}


#[macro_export]
#[doc(hidden)]
macro_rules! quote_token_spanned {
    ($ident:ident $tokens:ident $span:ident) => {
        $crate::__private::push_ident_spanned(&mut $tokens, $span, stringify!($ident));
    };

    (:: $tokens:ident $span:ident) => {
        $crate::__private::push_colon2_spanned(&mut $tokens, $span);
    };

    (( $($inner:tt)* ) $tokens:ident $span:ident) => {
        $crate::__private::push_group_spanned(
            &mut $tokens,
            $span,
            $crate::__private::Delimiter::Parenthesis,
            $crate::quote_spanned!($span=> $($inner)*),
        );
    };

    ([ $($inner:tt)* ] $tokens:ident $span:ident) => {
        $crate::__private::push_group_spanned(
            &mut $tokens,
            $span,
            $crate::__private::Delimiter::Bracket,
            $crate::quote_spanned!($span=> $($inner)*),
        );
    };

    ({ $($inner:tt)* } $tokens:ident $span:ident) => {
        $crate::__private::push_group_spanned(
            &mut $tokens,
            $span,
            $crate::__private::Delimiter::Brace,
            $crate::quote_spanned!($span=> $($inner)*),
        );
    };

    (# $tokens:ident $span:ident) => {
        $crate::__private::push_pound_spanned(&mut $tokens, $span);
    };

    (, $tokens:ident $span:ident) => {
        $crate::__private::push_comma_spanned(&mut $tokens, $span);
    };

    (. $tokens:ident $span:ident) => {
        $crate::__private::push_dot_spanned(&mut $tokens, $span);
    };

    (; $tokens:ident $span:ident) => {
        $crate::__private::push_semi_spanned(&mut $tokens, $span);
    };

    (: $tokens:ident $span:ident) => {
        $crate::__private::push_colon_spanned(&mut $tokens, $span);
    };

    (+ $tokens:ident $span:ident) => {
        $crate::__private::push_add_spanned(&mut $tokens, $span);
    };

    (+= $tokens:ident $span:ident) => {
        $crate::__private::push_add_eq_spanned(&mut $tokens, $span);
    };

    (& $tokens:ident $span:ident) => {
        $crate::__private::push_and_spanned(&mut $tokens, $span);
    };

    (&& $tokens:ident $span:ident) => {
        $crate::__private::push_and_and_spanned(&mut $tokens, $span);
    };

    (&= $tokens:ident $span:ident) => {
        $crate::__private::push_and_eq_spanned(&mut $tokens, $span);
    };

    (@ $tokens:ident $span:ident) => {
        $crate::__private::push_at_spanned(&mut $tokens, $span);
    };

    (! $tokens:ident $span:ident) => {
        $crate::__private::push_bang_spanned(&mut $tokens, $span);
    };

    (^ $tokens:ident $span:ident) => {
        $crate::__private::push_caret_spanned(&mut $tokens, $span);
    };

    (^= $tokens:ident $span:ident) => {
        $crate::__private::push_caret_eq_spanned(&mut $tokens, $span);
    };

    (/ $tokens:ident $span:ident) => {
        $crate::__private::push_div_spanned(&mut $tokens, $span);
    };

    (/= $tokens:ident $span:ident) => {
        $crate::__private::push_div_eq_spanned(&mut $tokens, $span);
    };

    (.. $tokens:ident $span:ident) => {
        $crate::__private::push_dot2_spanned(&mut $tokens, $span);
    };

    (... $tokens:ident $span:ident) => {
        $crate::__private::push_dot3_spanned(&mut $tokens, $span);
    };

    (..= $tokens:ident $span:ident) => {
        $crate::__private::push_dot_dot_eq_spanned(&mut $tokens, $span);
    };

    (= $tokens:ident $span:ident) => {
        $crate::__private::push_eq_spanned(&mut $tokens, $span);
    };

    (== $tokens:ident $span:ident) => {
        $crate::__private::push_eq_eq_spanned(&mut $tokens, $span);
    };

    (>= $tokens:ident $span:ident) => {
        $crate::__private::push_ge_spanned(&mut $tokens, $span);
    };

    (> $tokens:ident $span:ident) => {
        $crate::__private::push_gt_spanned(&mut $tokens, $span);
    };

    (<= $tokens:ident $span:ident) => {
        $crate::__private::push_le_spanned(&mut $tokens, $span);
    };

    (< $tokens:ident $span:ident) => {
        $crate::__private::push_lt_spanned(&mut $tokens, $span);
    };

    (*= $tokens:ident $span:ident) => {
        $crate::__private::push_mul_eq_spanned(&mut $tokens, $span);
    };

    (!= $tokens:ident $span:ident) => {
        $crate::__private::push_ne_spanned(&mut $tokens, $span);
    };

    (| $tokens:ident $span:ident) => {
        $crate::__private::push_or_spanned(&mut $tokens, $span);
    };

    (|= $tokens:ident $span:ident) => {
        $crate::__private::push_or_eq_spanned(&mut $tokens, $span);
    };

    (|| $tokens:ident $span:ident) => {
        $crate::__private::push_or_or_spanned(&mut $tokens, $span);
    };

    (? $tokens:ident $span:ident) => {
        $crate::__private::push_question_spanned(&mut $tokens, $span);
    };

    (-> $tokens:ident $span:ident) => {
        $crate::__private::push_rarrow_spanned(&mut $tokens, $span);
    };

    (<- $tokens:ident $span:ident) => {
        $crate::__private::push_larrow_spanned(&mut $tokens, $span);
    };

    (% $tokens:ident $span:ident) => {
        $crate::__private::push_rem_spanned(&mut $tokens, $span);
    };

    (%= $tokens:ident $span:ident) => {
        $crate::__private::push_rem_eq_spanned(&mut $tokens, $span);
    };

    (=> $tokens:ident $span:ident) => {
        $crate::__private::push_fat_arrow_spanned(&mut $tokens, $span);
    };

    (<< $tokens:ident $span:ident) => {
        $crate::__private::push_shl_spanned(&mut $tokens, $span);
    };

    (<<= $tokens:ident $span:ident) => {
        $crate::__private::push_shl_eq_spanned(&mut $tokens, $span);
    };

    (>> $tokens:ident $span:ident) => {
        $crate::__private::push_shr_spanned(&mut $tokens, $span);
    };

    (>>= $tokens:ident $span:ident) => {
        $crate::__private::push_shr_eq_spanned(&mut $tokens, $span);
    };

    (* $tokens:ident $span:ident) => {
        $crate::__private::push_star_spanned(&mut $tokens, $span);
    };

    (- $tokens:ident $span:ident) => {
        $crate::__private::push_sub_spanned(&mut $tokens, $span);
    };

    (-= $tokens:ident $span:ident) => {
        $crate::__private::push_sub_eq_spanned(&mut $tokens, $span);
    };

    ($lifetime:lifetime $tokens:ident $span:ident) => {
        $crate::__private::push_lifetime_spanned(&mut $tokens, $span, stringify!($lifetime));
    };

    (_ $tokens:ident $span:ident) => {
        $crate::__private::push_underscore_spanned(&mut $tokens, $span);
    };

    ($other:tt $tokens:ident $span:ident) => {
        $crate::__private::parse_spanned(&mut $tokens, $span, stringify!($other));
    };
}
