% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aat_covreliability.R
\name{aat_stimulusscores}
\alias{aat_stimulusscores}
\title{Compute stimulus-specific bias scores
Computes mean single-difference scores (push - pull) for each stimulus.}
\usage{
aat_stimulusscores(
  ds,
  subjvar,
  stimvar,
  pullvar,
  targetvar = NULL,
  rtvar,
  aggfunc = c("mean", "median"),
  iters = 5
)
}
\arguments{
\item{ds}{the \code{data.frame} to use}

\item{subjvar}{Name of the subject-identifying variable}

\item{stimvar}{Name of the stimulus-identifying variable}

\item{pullvar}{Name of the movement-direction identifying variable}

\item{targetvar}{Optional. Name of the stimulus-category identifying variable}

\item{rtvar}{Name of the reaction-time identifying variable}

\item{aggfunc}{The function with which to aggregate the RTs before computing difference scores. Defaults to mean but can be changed to median.}

\item{iters}{If there are missing values (which is almost inevitable) then
multiple imputation will be used to complete the covariance matrix - this argument sets
the number of multiple imputations to be used.}
}
\value{
Exports a \code{list} containing
a \code{data.frame} with stimulus-specific bias scores, indicated in the column names,
a covariance matrix of that same data, and
a \code{data.frame} indicating to which stimulus category each stimulus belongs.
}
\description{
Compute stimulus-specific bias scores
Computes mean single-difference scores (push - pull) for each stimulus.
}
\examples{
ds<-aat_simulate(biasfx_jitter=40,nstims=16)
ds$stim<-paste0(ds$stim,"-",ds$is_target)
aat_stimulusscores(ds,"subj","stim","is_pull","is_target","rt")
}
