% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relcorrections.R
\name{covrel}
\alias{covrel}
\alias{calpha}
\alias{lambda2}
\alias{lambda4}
\title{Covariance Matrix-Based Reliability Coefficients}
\usage{
calpha(covmat)

lambda2(covmat)

lambda4(covmat)
}
\arguments{
\item{covmat}{a covariance matrix}
}
\description{
These functions allow for the computation of the reliability of a dataset
from the covariance matrix of its variables.
}
\section{Functions}{
\itemize{
\item \code{calpha()}: Cronbach's alpha

\item \code{lambda2()}: Guttman's Lambda-2

\item \code{lambda4()}: Guttman's Lambda-4. This algorithm tries to get the highest attainable reliability by

}}
\examples{
# compute reliability from covariance
h<-cov(iris[,1:4])
calpha(h)
lambda2(h)
lambda4(h)
# Lambda-2 and Lambda-4 are significantly larger because
# some of the variables in the iris dataset are negatively correlated.
}
\seealso{
\link{splitrel}
}
