% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popSummary.R
\name{meanEBV}
\alias{meanEBV}
\title{Mean estimated breeding values}
\usage{
meanEBV(pop)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}} or \code{\link{HybridPop-class}}}
}
\description{
Returns the mean estimated breeding values for all traits
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
trtH2 = 0.5
SP$setVarE(h2=trtH2)
\dontshow{SP$nThreads = 1L}

#Create population
pop = newPop(founderPop, simParam=SP)
pop@ebv = trtH2 * (pop@pheno - meanP(pop)) #ind performance based EBV
meanEBV(pop)

}
