% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_coclustering.R
\name{AM_clustering}
\alias{AM_clustering}
\title{Return the clustering matrix}
\usage{
AM_clustering(fit)
}
\arguments{
\item{fit}{an \code{\link{AM_mcmc_output}} object.}
}
\value{
A numeric clustering matrix
}
\description{
Given an \code{\link{AM_mcmc_output}} object, this function returns the clustering matrix.
}
\details{
The clustering matrix is an M by n matrix. Each of the M rows represents a clustering of n items
using cluster labels. Items i and j are in the same cluster if fit[m,i] == fit[m,j] for the mth clustering.
}
\examples{
\donttest{
fit = AM_demo_uvp_poi()$fit
ccm <- AM_clustering(fit)
}
}
\seealso{
\code{\link{AM_coclustering}}
}
