% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frontend.R
\name{get_error_response}
\alias{get_error_response}
\title{Get the last error message of a query object}
\usage{
get_error_response(query)
}
\arguments{
\item{query}{A query object to return the error string of}
}
\value{
The error string of a failing response object, or "No error" if the query
didn't fail
}
\description{
Returns the error string returned from Arctos if the last response in a
query object returned a status code other than HTTP 200 for debugging
purposes.
}
\examples{
library(ArctosR)

# query with an invalid column name 'paarts'
query <- get_records(
  scientific_name = "Canis lupus", guid_prefix = "MSB:Mamm",
  columns = list("guid", "paarts", "partdetail")
)

get_error_response(query)

}
