% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring.R
\name{chiScores}
\alias{chiScores}
\alias{miScores}
\alias{randScores}
\title{Scoring functions to choose splits}
\usage{
chiScores(vals, expn, minExp = 0)

miScores(vals, expn, minExp = 0)

randScores(vals, expn, minExp = 0)
}
\arguments{
\item{vals}{numeric vector candidate splits and bounds}

\item{expn}{the expected number of points in the bin}

\item{minExp}{the minimum number of points allowed in a bin}
}
\value{
A vector of scores.
}
\description{
These functions define scores to evaluate candidate
splits along a single margin within partition.
}
\details{
Scorings

Each of these functions accepts `vals`, an ordered
numeric vector containing the candidate splits within a bin and
the bin bounds all in increasing order. To restrict splitting,
they also accept `expn` and `minExp`, which provide the expected
count within the split and minimum value of this count,
respectively. Any split which produces an expected value less
than `minExp` (assuming a uniform density within the bin) is given
a score of zero.
}
\section{Functions}{
\itemize{
\item \code{chiScores()}: A chi-squared statistic score

\item \code{miScores()}: A mutual information score

\item \code{randScores()}: A random score for random splitting

}}
\examples{
vals <- c(2, 5, 12, 16, 19)
## restricting the minExp changes output
chiScores(vals, 4, minExp = 0)
chiScores(vals, 4, minExp = 2)
## same for the miScores
miScores(vals, 4, minExp = 0)
miScores(vals, 4, minExp = 2)
## random scoring produces different output every time
randScores(vals, 4, minExp = 0)
randScores(vals, 4, minExp = 0)
}
\author{
Chris Salahub
}
