% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour.R
\name{contour.bcea}
\alias{contour.bcea}
\alias{contour}
\title{Contour Plots for the Cost-Effectiveness Plane}
\usage{
\method{contour}{bcea}(
  he,
  scale = 0.5,
  nlevels = 4,
  levels = NULL,
  pos = c(1, 0),
  xlim = NULL,
  ylim = NULL,
  graph = c("base", "ggplot2"),
  ...
)

contour(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{scale}{Scales the plot as a function of the observed standard deviation.}

\item{nlevels}{Number of levels to be plotted in the contour.}

\item{levels}{Numeric vector of levels at which to draw contour lines.
Will be ignored using \code{graph="ggplot2"}.}

\item{pos}{Parameter to set the position of the legend (only relevant for
multiple interventions, ie more than 2 interventions being compared).
Can be given in form
of a string \code{(bottom|top)(right|left)} for base graphics and
\code{bottom|top|left|right} for ggplot2. It can be a two-elements vector,
which specifies the relative position on the x and y axis respectively, or
alternatively it can be in form of a logical variable, with \code{FALSE}
indicating to use the default position and \code{TRUE} to place it on the
bottom of the plot.}

\item{xlim}{The range of the plot along the x-axis. If NULL (default) it is
determined by the range of the simulated values for \code{delta_e}}

\item{ylim}{The range of the plot along the y-axis. If NULL (default) it is
determined by the range of the simulated values for \code{delta_c}}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-) match the two options \code{"base"} or
\code{"ggplot2"}. Default value is \code{"base"}.}

\item{...}{Additional arguments}
}
\value{
\item{ceplane}{ A ggplot object containing the plot. Returned only
if \code{graph="ggplot2"}. } Plots the cost-effectiveness plane with a
scatterplot of all the simulated values from the (posterior) bivariate
distribution of (\eqn{\Delta_e, \Delta_c}), the differentials of effectiveness and
costs; superimposes a contour of the distribution and prints the estimated
value of the probability of each quadrant (combination of positive/negative
values for both \eqn{\Delta_e} and \eqn{\Delta_c})
}
\description{
Contour method for objects in the class \code{bcea}.
Produces a scatterplot of the cost-effectiveness plane, with a contour-plot
of the bivariate density of the differentials of cost (y-axis) and
effectiveness (x-axis).
}
\examples{
data(Vaccine)

# Runs the health economic evaluation using BCEA
m <- bcea(e=e,
          c=c,              # defines the variables of 
                            #  effectiveness and cost
      ref=2,                # selects the 2nd row of (e,c) 
                            #  as containing the reference intervention
      interventions=treats, # defines the labels to be associated 
                            #  with each intervention
      Kmax=50000,           # maximum value possible for the willingness 
                            #  to pay threshold; implies that k is chosen 
                            #  in a grid from the interval (0,Kmax)
      plot=TRUE             # plots the results
)

contour(m)
contour(m, graph = "ggplot2")

# Plots the contour and scatterplot of the bivariate 
# distribution of (Delta_e, Delta_c)
contour(m,          # uses the results of the economic evaluation 
                    #  (a "bcea" object)
      comparison=1, # if more than 2 interventions, selects the 
                    #  pairwise comparison 
      nlevels=4,    # selects the number of levels to be 
                    #  plotted (default=4)
      levels=NULL,  # specifies the actual levels to be plotted 
                    #  (default=NULL, so that R will decide)
      scale=0.5,    # scales the bandwidths for both x- and 
                    #  y-axis (default=0.5)
      graph="base"  # uses base graphics to produce the plot
)

}
\references{
Baio, G., Dawid, A. P. (2011). Probabilistic Sensitivity
Analysis in Health Economics. Statistical Methods in Medical Research
doi:10.1177/0962280211419832.

Baio G. (2012). Bayesian Methods in Health Economics. CRC/Chapman Hall, London.
}
\seealso{
\code{\link{bcea}},
         \code{\link{ceplane.plot}},
         \code{\link{contour2}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{"Bayesian}
\keyword{"Health}
\keyword{economic}
\keyword{evaluation"}
\keyword{model"}
