% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evi.plot.R
\name{evi.plot.bcea}
\alias{evi.plot.bcea}
\alias{evi.plot}
\title{Expected Value of Information (EVI) Plot}
\usage{
\method{evi.plot}{bcea}(he, graph = c("base", "ggplot2", "plotly"), ...)

evi.plot(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-)match the three options \code{"base"},
\code{"ggplot2"} or \code{"plotly"}. Default value is \code{"base"}.}

\item{...}{Additional graphical arguments:
\itemize{
  \item \code{line_colors} to specify the EVPI line colour - all graph types.
  \item \code{line_types} to specify the line type (lty) - all graph types.
  \item \code{area_include} to specify whether to include the area under the
  EVPI curve - plotly only.
  \item \code{area_color} to specify the area under the colour curve - plotly only.}}
}
\value{
\item{eib}{ If \code{graph="ggplot2"} a ggplot object, or if \code{graph="plotly"} 
  a plotly object containing the requested plot. Nothing is returned when \code{graph="base"}, 
  the default.} The function produces a plot of the
  Expected Value of Information as a function of the discrete grid
  approximation of the willingness to pay parameter. The break even point(s)
  (i.e. the point in which the EIB=0, ie when the optimal decision changes
  from one intervention to another) is(are) also showed.
}
\description{
Plots the Expected Value of Information (EVI) against the willingness to pay.
}
\examples{
data(Vaccine)
m <- bcea(
      e=e,
      c=c,                  # defines the variables of 
                            #  effectiveness and cost
      ref=2,                # selects the 2nd row of (e, c) 
                            #  as containing the reference intervention
      interventions=treats, # defines the labels to be associated 
                            #  with each intervention
      Kmax=50000,           # maximum value possible for the willingness 
                            #  to pay threshold; implies that k is chosen 
                            #  in a grid from the interval (0, Kmax)
      plot=FALSE            # plots the results
)
evi.plot(m)

data(Smoking)
treats <- c("No intervention", "Self-help",
            "Individual counselling", "Group counselling")
m <- bcea(e, c, ref = 4, interventions = treats, Kmax = 500)
evi.plot(m)

}
\references{
Baio, G., Dawid, A. P. (2011). Probabilistic Sensitivity
Analysis in Health Economics. Statistical Methods in Medical Research
doi:10.1177/0962280211419832.

Baio G. (2012). Bayesian Methods in Health Economics. CRC/Chapman Hall, London.
}
\seealso{
\code{\link{bcea}},
         \code{\link{ceac.plot}},
         \code{\link{ceplane.plot}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{Expected}
\keyword{Health}
\keyword{economic}
\keyword{evaluation}
\keyword{information}
\keyword{of}
\keyword{value}
