% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bcea.R
\name{summary.bcea}
\alias{summary.bcea}
\title{Summary Method for Objects of Class \code{bcea}}
\usage{
\method{summary}{bcea}(object, wtp = 25000, ...)
}
\arguments{
\item{object}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{wtp}{The value of the willingness to pay threshold used in the summary table.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
Prints a summary table with some information on the health economic
output and synthetic information on the economic measures (EIB, CEAC, EVPI).
}
\description{
Produces a table printout with some summary results of the health economic
evaluation.
}
\examples{
data(Vaccine)

he <- bcea(eff, cost, interventions = treats, ref = 2)
summary(he)

}
\references{
\insertRef{Baio2011}{BCEA}

\insertRef{Baio2013}{BCEA}
}
\seealso{
\code{\link{bcea}}
}
\author{
Gianluca Baio
}
\keyword{print}
