% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.bgvar.R
\name{print.bgvar.lps}
\alias{print.bgvar.lps}
\title{Print prediction evaulation}
\usage{
\method{print}{bgvar.lps}(x, ...)
}
\arguments{
\item{x}{an object of class \code{bgvar.lps}.}

\item{...}{other arguments.}
}
\value{
No return value.
}
\description{
\code{print} prints log-predictive scores (LPS) of out-of-sample predictions computed with \code{bgvar.predict}.
}
\examples{
\dontshow{
library(BGVAR)
data(eerData)
cN<-c("EA","US","UK")
eerData<-eerData[cN]
W.trade0012<-apply(W.trade0012[cN,cN],2,function(x)x/rowSums(W.trade0012[cN,cN]))
model.ssvs.eer<-bgvar(Data=eerData,W=W.trade0012,saves=100,burns=100,plag=1,prior="SSVS",
                      eigen=TRUE,h=8)
fcast <- predict(model.ssvs.eer,fhorz=8,save.store=TRUE)
lps(fcast)
}
\donttest{
library(BGVAR)
data(eerData)
model.ssvs.eer<-bgvar(Data=eerData,W=W.trade0012,saves=100,burns=100,plag=1,prior="SSVS",
                      eigen=TRUE,h=8)
fcast <- predict(model.ssvs.eer,fhorz=8,save.store=TRUE)
lps(fcast)
}
}
\seealso{
\code{\link{bgvar}} to estimate a \code{bgvar} object and \code{\link{predict.bgvar}} to compute predictions.
}
\author{
Maximilian Boeck, Martin Feldkircher
}
