% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.R
\name{irfcf}
\alias{irfcf}
\alias{irfcf.bgvar.irf}
\title{Counterfactual Analysis}
\usage{
irfcf(x, shockvar, resp, n.ahead=24, save.store=FALSE, verbose=TRUE)
}
\arguments{
\item{x}{an object of class \code{bgvar}.}

\item{shockvar}{structural shock of interest.}

\item{resp}{response variable to neutralize.}

\item{n.ahead}{forecasting horizon.}

\item{save.store}{If set to \code{TRUE} the full posterior is returned. Default is set to \code{FALSE} in order to save storage.}

\item{verbose}{If set to \code{FALSE} it suppresses printing messages to the console.}
}
\value{
Returns a list of class \code{bgvar.irf} with the following elements: \itemize{
\item{\code{posterior}}{ is a four-dimensional array (K times K times n.ahead times 7) that contains 7 quantiles of the posterior distribution of the impulse response functions: the 50\% ("low25" and "high75"), the 68\% ("low16" and "high84") and the 90\% ("low05" and "high95") credible sets along with the posterior median ("median").}
\item{\code{struc.obj}}{ is a list object that contains posterior quantitites needed when calculating historical decomposition and structural errors via \code{hd.decomp}.\itemize{
\item{\code{A}}{ median posterior of global coefficient matrix.}
\item{\code{Ginv}}{ median posterior of matrix \code{Ginv}, which describes contemporaneous relationships between countries.}
\item{\code{S}}{ posterior median of matrix with country variance-covariance matrices on the main diagonal.}
}}
\item{\code{model.obj}}{ is a list object that contains model-specific information, in particular\itemize{
\item{\code{xglobal}}{ used data of the model.}
\item{\code{plag}}{ used lag specification of the model.}
}}
\item{\code{IRF_store}}{ is a four-dimensional array (K times n.ahead times nr. of shock times draws) which stores the whole posterior distribution. Exists only if \code{save.irf.store=TRUE}.}
}
}
\description{
Function to perform counterfactual analysis. It enables to neutralize the response of a specific variable to a given shock.
}
\examples{
\donttest{
library(BGVAR)
data(eerData)
model.ssvs.eer<-bgvar(Data=eerData,W=W.trade0012,draws=100,burnin=100,plag=1,prior="SSVS",
                      eigen=TRUE)
}
# very time-consuming
\dontrun{
irfcf <- irfcf(model.ssvs.eer,shockvar="US.stir",resp="US.rer",n.ahead=24)
}
}
\author{
Maximilian Boeck, Martin Feldkircher
}
