% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DetectCpObj.R
\name{DetectCpObj}
\alias{DetectCpObj}
\title{DetectCpObj class constructor}
\usage{
DetectCpObj(
  data = NULL,
  n_iterations = NULL,
  n_burnin = NULL,
  orders = NULL,
  time = NULL,
  phi_MCMC = NULL,
  phi_MCMC_01 = NULL,
  sigma_MCMC = NULL,
  sigma_MCMC_01 = NULL,
  theta_MCMC = NULL,
  I0_MCMC = NULL,
  I0_MCMC_01 = NULL,
  kernel_ts = NULL,
  kernel_epi = NULL,
  univariate_ts = NULL
)
}
\arguments{
\item{data}{a vector or a matrix containing the values of the time series;}

\item{n_iterations}{number of iterations of the MCMC algorithm;}

\item{n_burnin}{number of MCMC iterations to exclude in the posterior estimate;}

\item{orders}{a matrix where each row corresponds to the output order of the corresponding iteration;}

\item{time}{computational time in seconds;}

\item{phi_MCMC}{traceplot for \eqn{\gamma}.}

\item{phi_MCMC_01}{a \eqn{0/1} vector, the \eqn{n}-th element is equal to \eqn{1} if the proposed \eqn{\phi} was accepted, \eqn{0} otherwise.}

\item{sigma_MCMC}{traceplot for \eqn{\sigma}.}

\item{sigma_MCMC_01}{a \eqn{0/1} vector, the \eqn{n}-th element is equal to \eqn{1} if the proposed \eqn{\sigma} was accepted, \eqn{0} otherwise.}

\item{theta_MCMC}{traceplot for \eqn{\theta}.}

\item{I0_MCMC}{traceplot for \eqn{I_0}.}

\item{I0_MCMC_01}{a \eqn{0/1} vector, the \eqn{n}-th element is equal to \eqn{1} if the proposed \eqn{I_0} was accepted, \eqn{0} otherwise.}

\item{kernel_ts}{if TRUE data are time series.}

\item{kernel_epi}{if TRUE data are survival functions.}

\item{univariate_ts}{TRUE/FALSE if time series is univariate or not.}
}
\description{
A constructor for the \code{DetectCpObj} class. The class \code{DetectCpObj} contains...
}
