% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsFisher-functions.R
\name{vMF}
\alias{vMF}
\alias{dvMFnim}
\alias{rvMFnim}
\title{von-mises Fisher distribution}
\usage{
dvMFnim(x, theta, log = 0)

rvMFnim(n, theta)
}
\arguments{
\item{x}{vector of direction}

\item{theta}{vector of direction}

\item{log}{logical; If TRUE, probabilities p are given as log(p)}

\item{n}{number of observations}
}
\value{
\itemize{
\item \code{dvMFnim()} : scalar numeric (density or log-density).
\item \code{rvMFnim()} : numeric vector of length \eqn{p}. To register distribution for nimble, only one vector is generated.
}
}
\description{
Density, and random generation for von-mises Fisher distribution.
}
\details{
\itemize{
\item \code{dvMFnim(x, theta, log)} evaluates the log-density
\deqn{\log f(x|\theta) = \theta^\top x - \left[\log I_\nu(\kappa) + \log \Gamma(\nu) - (\nu-1)\log(\kappa/2)\right],}
with \eqn{\nu = p/2}, \eqn{\kappa = \|\theta\|_2}.
\item \code{rvMFnim(n, theta)} returns one vector on the unit sphere.
If \eqn{\kappa=0}, it generates a uniform random direction.
}
}
\references{
Wood, Andrew TA. "Simulation of the von Mises Fisher distribution." \emph{Communications in statistics-simulation and computation} 23.1 (1994): 157-164.

Hornik, K., & Grün, B. (2014). movMF: an R package for fitting mixtures of von Mises-Fisher distributions.
\emph{Journal of Statistical Software}, 58, 1-31.
}
