% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jointness.R
\name{print.jointness}
\alias{print.jointness}
\title{Print an object of class \code{jointness}}
\usage{
\method{print}{jointness}(x, ...)
}
\arguments{
\item{x}{An object of class \code{jointness}}

\item{...}{Additional parameters to be passed}
}
\description{
Print an object of class \code{jointness}. Show the different jointness measurements with a small explanation.
}
\examples{

\dontrun{
#Analysis of Crime Data
#load data
data(UScrime)

#Default arguments are Robust prior for the regression parameters
#and constant prior over the model space
#Here we keep the 1000 most probable models a posteriori:
crime.Bvs<- Bvs(formula= y ~ ., data=UScrime, n.keep=1000)

#A look at the results:
jointness(crime.Bvs)
}

}
\seealso{
See \code{\link[BayesVarSel]{Jointness}} for creating objects of the class
  \code{jointness}.
}
\author{
Gonzalo Garcia-Donato and Anabel Forte

  Maintainer: <anabel.forte@uv.es>
}
