% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamaMacBeth.R
\name{Two_Pass_Regression}
\alias{Two_Pass_Regression}
\title{Fama MacBeth Two-Pass Regression}
\usage{
Two_Pass_Regression(f, R)
}
\arguments{
\item{f}{A matrix of factors with dimension \eqn{t \times k}, where \eqn{k} is the number of factors
and \eqn{t} is the number of periods;}

\item{R}{A matrix of test assets with dimension \eqn{t \times N}, where \eqn{t} is the number of periods
and \eqn{N} is the number of test assets;}
}
\value{
The return of \code{Two_Pass_Regression} is a list of the following elements:
\itemize{
\item lambda: Risk premia estimates in the OLS two-pass regression;
\item lambda_gls: Risk premia estimates in the GLS two-pass regression;
\item t_stat: The t-statistics of risk premia estimates in the OLS two-pass regression;
\item t_stat_gls: The t-statistics of risk premia estimates in the GLS two-pass regression;
\item R2_adj: Adjusted \eqn{R2} in the OLS two-pass regression;
\item R2_adj_GLS: Adjusted \eqn{R2} in the GLS two-pass regression.
}
}
\description{
This function provides the frequentist Fama-MacBeth Two-Pass Regression.
}
\details{
See Chapter 12.2 in \insertCite{cochrane2009asset;textual}{BayesianFactorZoo}. \code{t_stat} and \code{t_stat_gls}
are t-statistics of OLS and GLS risk premia estimates based on the asymptotic standard errors in equation (12.19) in
\insertCite{cochrane2009asset;textual}{BayesianFactorZoo}.
}
\references{
\insertRef{cochrane2009asset}{BayesianFactorZoo}
}
