% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdWrite_hdf5_dimnames}
\alias{bdWrite_hdf5_dimnames}
\title{Write dimnames to an HDF5 dataset}
\usage{
bdWrite_hdf5_dimnames(filename, group, dataset, rownames, colnames)
}
\arguments{
\item{filename}{Character string. Path to the HDF5 file.}

\item{group}{Character string. Group containing the dataset.}

\item{dataset}{Character string. Dataset name inside \code{group}.}

\item{rownames}{Character vector of row names. Use \code{character(0)}
to skip writing row names. If provided, length must equal nrow.}

\item{colnames}{Character vector of column names. Use
\code{character(0)} to skip writing column names. If provided,
length must equal ncol.}
}
\value{
List with components. If an error occurs, all string values are returned as empty strings (""):
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{dsrows}{Character string with the full dataset path to the row names,
stored as ".\code{dataset}_dimnames/1" within the specified group}
\item{dscols}{Character string with the full dataset path to the column
names, stored as ".\code{dataset}_dimnames/2" within the specified group}
}
}
\description{
Write row and/or column names metadata for an existing dataset in an
HDF5 file. Empty vectors skip the corresponding dimnames.
}
\details{
The dataset \code{group/dataset} must already exist. When non-empty,
\code{rownames} and \code{colnames} lengths are validated against the
dataset dimensions.
}
\examples{
\dontrun{
bdWrite_hdf5_dimnames(
  filename = "test.h5",
  group = "MGCCA_IN",
  dataset = "X",
  rownames = paste0("r", seq_len(100)),
  colnames = paste0("c", seq_len(50))
)

# Skip column names:
bdWrite_hdf5_dimnames("test.h5", "MGCCA_IN", "X",
                      rownames = paste0("r", 1:100),
                      colnames = character(0))
}

}
