% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseQuantile.R
\name{summariseQuantile}
\alias{summariseQuantile}
\title{Quantile calculation using dbplyr}
\usage{
summariseQuantile(.data, x = NULL, probs, nameSuffix = "value")
}
\arguments{
\item{.data}{lazy data frame backed by a database query.}

\item{x}{column name whose sample quantiles are wanted.}

\item{probs}{numeric vector of probabilities with values in [0,1].}

\item{nameSuffix}{character; is appended to numerical quantile value as a column name part.}
}
\value{
An object of the same type as '.data'
}
\description{
This function provides DBMS independent syntax for quantiles estimation.
Can be used by itself or in combination with \code{mutate()}
when calculating other aggregate metrics (min, max, mean).

\code{summarise_quantile()}, \code{summarize_quantile()}, \code{summariseQuantile()} and \code{summarizeQuantile()} are synonyms.
}
\details{
Implemented quantiles estimation algorithm returns values analogous to
\verb{quantile\{stats\}} with argument \code{type = 1}.
See discussion in Hyndman and Fan (1996).
Results differ from \code{PERCENTILE_CONT} natively implemented in various DBMS,
where returned values are equal to \verb{quantile\{stats\}} with default argument \code{type = 7}
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb())
mtcars_tbl <- dplyr::copy_to(con, mtcars, name = "tmp", overwrite = TRUE, temporary = TRUE)

df <- mtcars_tbl \%>\%
 dplyr::group_by(cyl) \%>\%
 dplyr::mutate(mean = mean(mpg, na.rm = TRUE)) \%>\%
 summariseQuantile(mpg, probs = c(0, 0.2, 0.4, 0.6, 0.8, 1),
                   nameSuffix = "quant") \%>\%
 dplyr::collect()

DBI::dbDisconnect(con, shutdown = TRUE)
}
}
