% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbabilityFunctions.R
\name{rchangepoint}
\alias{rchangepoint}
\title{Simulate Univariate Data With a Single Change Point}
\usage{
rchangepoint(n, changepoint = NULL, mean1 = 0, mean2 = 0,
  dist = rnorm, meanparam = "mean", ...)
}
\arguments{
\item{n}{An integer for the data set's sample size}

\item{changepoint}{An integer for where the change point occurs}

\item{mean1}{The mean prior to the change point}

\item{mean2}{The mean after the change point}

\item{dist}{The function with which random data will be generated}

\item{meanparam}{A string for the parameter in \code{dist} representing the
mean}

\item{...}{Other arguments to be passed to dist}
}
\value{
A vector of the simulated data
}
\description{
This function simulates univariate data with a structural change.
}
\details{
This function generates artificial change point data, where up to the
specified change point the data has one mean, and after the point it has a
different mean. By default, the function simulates standard Normal data with
no change. If \code{changepoint} is \code{NULL}, then by default the change
point will be at about the middle of the data.
}
\examples{
CPAT:::rchangepoint(500)
CPAT:::rchangepoint(500, changepoint = 10, mean2 = 2, sd = 2)
CPAT:::rchangepoint(500, changepoint = 250, dist = rexp, meanparam = "rate",
                    mean1 = 1, mean2 = 2)
}
