% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StParm.R
\name{StParm}
\alias{StParm}
\title{Create an instance of a Structural parameter.}
\usage{
StParm(
  StParmName = character(),
  Type = "LogNormal",
  State = "Present",
  ThetaStParm = list(),
  OmegaStParm = list(),
  Covariates = list(),
  PMLStructure = character()
)
}
\arguments{
\item{StParmName}{Character specifying the name of the structural parameter.}

\item{Type}{Character specifying the type of the structural parameter. Options are
\itemize{
\item \code{LogNormal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = tvV * wt^dVdwt * exp(nV + nVx0*(Occasion==0) + nVx1*(Occasion==1)))}
\itemize{
\item \code{LogNormal1} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = (tvV + wt*dVdwt) * exp(nV + nVx0*( Occasion==0) + nVx1*( Occasion==1)))}
\itemize{
\item \code{LogNormal2} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = exp(tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occason==1)))}
\itemize{
\item \code{LogitNormal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = ilogit(tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occasion==1)))}
\itemize{
\item \code{Normal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occasion==1))}}

\item{State}{character string that indicates the presence of the structural
parameter. Options are:
\itemize{
\item \code{None} The structural parameter does not exist in the specified \code{PMLStructures}.
\item \code{Present} The structural parameter exists in the specified \code{PMLStructures} (the default).
\item \code{Searched} The presence of the structural parameter  is searched.
}}

\item{ThetaStParm}{A Theta class instance inside the structural parameter. If
not given, the associated Theta will be automatically created with its name
set to "tv" + \code{StParmName}.}

\item{OmegaStParm}{An Omega class instance inside the structural parameter.
If not given, the associated Omega will be automatically created with its
name set to "n" + \code{StParmName}}

\item{Covariates}{A list of covariates (\code{Covariate} instances) that should be
included in the structural parameter statement.}

\item{PMLStructure}{Character  specifying the name of PML
structure for which current parameter should be attributed. For the
naming convention of PMLStructures, see Details section of
\code{\link[=create_ModelPK]{create_ModelPK()}} for PK models and \code{\link[=create_ModelPD]{create_ModelPD()}} for PD models.}
}
\value{
An instance of a structural parameter.
}
\description{
This function creates a new instance of a Structural parameter.
}
\examples{

# Create a Structural parameter instance with default values
V <- StParm(StParmName = "V")

# Create a Structural parameter with Normal type:
V2 <- StParm("V2",
       Type = "Normal",
       ThetaStParm = Theta(Name = "tvV2", InitialEstimates = 0.1))

# Create a Structural parameter instance with covariates:
Cl <- StParm(
  StParmName = "Cl",
  Covariates = Covariate(
    Name = "Period",
    Type = "Occasion",
    State = "Searched",
    Categories = c(1,2),
    Omegas = list(Omega(Name = "nPeriodx1", 2),
                  Omega(Name = "nPeriodx2", 3))),
  PMLStructure = "1CFOE")

}
\seealso{
Functions used for StParm specification: 
\code{\link{add_StParm}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_StParm}()},
\code{\link{modify_StParmCustom}()},
\code{\link{remove_StParm}()}
}
\concept{StParms}
