% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_CustomSpace.R
\name{create_CustomSpace}
\alias{create_CustomSpace}
\title{Create a Custom Space}
\usage{
create_CustomSpace(CustomCode = character())
}
\arguments{
\item{CustomCode}{A character string containing the custom code.}
}
\value{
A list with one element of the class \code{PMLModels}.
}
\description{
This function creates a custom space object based on the provided custom
code.
}
\details{
This function parses the provided \code{CustomCode} and extracts
information related to:
\itemize{
\item Responses/observations (\code{observe}, \code{multi}, \code{ordinal}, \code{count}, \code{event}, and \code{LL})
\item Structural parameters (\code{stparm})
\item Covariates (\code{covariate}, \code{fcovariate} and \code{interpolate})
\item Dosepoints (\code{dosepoint} and \code{dosepoint2})
\item Random effects (\code{ranef})
\item Fixed effects (\code{fixef})
\item Derivatives (\code{deriv})
\item Urine compartments (\code{urinecpt})
\item Closed Form statements (\code{cfMicro}, \code{cfMacro} and \code{cfMacro1})
\item Distributed delay statements (\code{transit} and \code{delayInfCpt})
}

The extracted information is then used to create a \code{CustomSpace} object,
which contains the parsed and structured representation of the custom code.
An identifier is generated and used as the name of the Space.
}
