% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfS_Beta.R
\name{cfS_Beta}
\alias{cfS_Beta}
\title{Characteristic function of Beta distribution}
\usage{
cfS_Beta(t, theta = 1)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{theta}{default value theta = 1}
}
\value{
characteristic function cf(t) of the Beta distribution
}
\description{
cfX_Beta(t,alpha, beta) evaluates the characteristic function cf(t) of
the symmetric zero-mean Beta distribution with shape parameter theta >0,
defined on the interval (-1,1), i.e. symmetric beta distribution with
zero mean and variance VAR = 1/(1+2*theta). The standard deviation is
given by STD = sqrt(1/(1+2*theta))), i.e.
cf(t) = cfS_Beta(t,theta)
      = gamma(1/2+theta) * (t/2)^(1/2-theta) * besselj(theta-1/2,t).
Special cases (for specific values of the shape parameter theta):
 1) theta = 1/2; Arcsine distribution on (-1,1):     cf(t) = besselj(0,t).
 2) theta = 1;   Rectangular distribution on (-1,1): cf(t) = sin(t)/t;
}
\examples{
## EXAMPLE1 (CF of the Beta distribution with alpha = 1/2, beta = 3/2)
alpha <- 1 / 2
beta <- 3 / 2
t <- seq(-50, 50, length.out = 501)
plotGraf(function(t)
  cfX_Beta(t, alpha, beta), t, title = "CF of the Beta distribution with alpha = 1/2, beta = 3/2")

## EXAMPLE2 (PDF/CDF of the Beta distribution with alpha = 1/2, beta = 3/2)
alpha <- 1 / 2
beta <- 3 / 2
cf <- function(t)
  cfX_Beta(t, alpha, beta)
x <- seq(0, 1, length.out = 101)
xRange <- 1
option <- list()
option$dx <- 2 * pi / xRange
result <- cf2DistGP(cf, x, option = option)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Beta_distribution}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}, \code{\link{cfX_Beta}},
  \code{\link{cfX_ChiSquared}},
  \code{\link{cfX_Exponential}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_InverseGamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}},
  \code{\link{cfX_Rectangular}},
  \code{\link{cfX_Triangular}}
}

