% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfX_InverseGamma.R
\name{cfX_InverseGamma}
\alias{cfX_InverseGamma}
\title{Characteristic function of Inverse Gamma distribution}
\usage{
cfX_InverseGamma(t, alpha = 1, beta = 1)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{alpha}{shape, alpha > 0, default value alpha = 1}

\item{beta}{rate > 0, default value beta = 1}
}
\value{
characteristic function cf(t) of the Inverse Gamma distribution
}
\description{
cfX_InverseGamma(t,alpha,beta) evaluates the characteristic function cf(t) of
the Inverse Gamma distribution with the parameters alpha (shape, alpha > 0) and
beta (rate, beta > 0), i.e.

cfX_InverseGamma(t, alpha, beta) = (1 - it/beta)^(-alpha)
}
\examples{
## EXAMPLE1 (CF of the InverseGamma distribution with alpha = 2, beta = 2)
alpha <- 2
beta <- 2
t <- seq(-20, 20, length.out = 501)
plotGraf(function(t)
  cfX_InverseGamma(t, alpha, beta), t,
  title = "CF of the InverseGamma distribution with alpha = 2, beta = 2")

## EXAMPLE2 (PDF/CDF of the InverseGamma distribution with alpha = 2, beta = 2)
alpha <- 2
beta <- 2
cf <- function(t)
  cfX_InverseGamma(t, alpha, beta)
x <- seq(0, 15, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf, x, prob, xMin = 0, N = 2 ^ 10)

## EXAMPLE3 (PDF/CDF of the compound Binomial-InverseGamma distribution)
p <- 0.3
n <- 25
alpha <- 2
beta <- 2
cfX <- function(t)
  cfX_InverseGamma(t, alpha, beta)
cf <- function(t)
  cfN_Binomial(t, n, p, cfX)
x <- seq(0, 70, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf, x, prob, isCompound = TRUE, N = 2 ^ 10)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Inverse-gamma_distribution}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Beta}}, \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}, \code{\link{cfX_Beta}},
  \code{\link{cfX_ChiSquared}},
  \code{\link{cfX_Exponential}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}},
  \code{\link{cfX_Rectangular}},
  \code{\link{cfX_Triangular}}
}

