% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAA-getDataCM.R, R/as.data.frame-climmob_list.R
\name{getDataCM}
\alias{getDataCM}
\alias{as.data.frame.CM_list}
\title{Get ClimMob data}
\usage{
getDataCM(
  key,
  project,
  userowner,
  as.data.frame = TRUE,
  as.text = FALSE,
  server = "climmob3",
  ...
)

\method{as.data.frame}{CM_list}(x, ..., tidynames = TRUE, pivot.wider = TRUE)
}
\arguments{
\item{key}{character, the user's API key}

\item{project}{character, the project id}

\item{userowner}{character, username of project's owner}

\item{as.data.frame}{logical, to return a data frame, as.data.frame = FALSE returns a list}

\item{as.text}{logical, to return a text file that can be parsed to json}

\item{server}{character, to indicate from which server the data will be retrieved. See details}

\item{...}{additional arguments passed to methods}

\item{x}{an object of class \code{CM_list}}

\item{tidynames}{logical, \code{TRUE} make clean column names}

\item{pivot.wider}{logical, if \code{TRUE} return a wider object 
where each tricot package is a row}
}
\value{
An object of class 'CM_list' or a text file or 
 a data.frame with class "CM_df" with the variables:
\item{id}{the participant's package id}
\item{moment}{the data collection moment}
\item{variable}{the variable name}
\item{value}{the value for each variable}
}
\description{
Fetch the data from a ClimMob project using an application 
 programming interface (API) key
}
\details{
\code{server}: options are: "climmob" or "1000farms"
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# This function only works with an API key
# the API key can be obtained from your ClimMob account
 
library("ClimMobTools")
my_key = "d39a3c66-5822-4930-a9d4-50e7da041e77"

getDataCM(key = my_key,
          project = "breadwheat",
          userowner = "gosset",
          server = "climmob3")
          
# get in the long format

getDataCM(key = my_key,
          project = "breadwheat",
          userowner = "gosset",
          server = "climmob3",
          pivot.wider = FALSE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other GET functions: 
\code{\link{getProjectProgress}()},
\code{\link{getProjectsCM}()}
}
\author{
Kauê de Sousa
}
\concept{GET functions}
