% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AppendCohortTables.R
\name{appendCohortTables}
\alias{appendCohortTables}
\title{Append cohort data from multiple cohort tables(s)}
\usage{
appendCohortTables(
  connectionDetails = NULL,
  connection = NULL,
  sourceTables,
  targetCohortDatabaseSchema = NULL,
  targetCohortTable,
  isTempTable = FALSE,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema")
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{sourceTables}{A data.frame object with the columns sourceCohortDatabaseSchema, sourceCohortTableName.}

\item{targetCohortDatabaseSchema}{Schema name where your target cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{targetCohortTable}{The name of the target cohort table.}

\item{isTempTable}{Is the output a temp table. If yes, a new temp table is created. This will required
an active connection. Any old temp table is dropped and replaced.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}
}
\value{
Nothing is returned
}
\description{
Append cohort data from multiple cohort tables.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
