% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortCount.R
\name{getCohortCounts}
\alias{getCohortCounts}
\title{Count the cohort(s)}
\usage{
getCohortCounts(
  connectionDetails = NULL,
  connection = NULL,
  cohortDatabaseSchema,
  cohortTable = "cohort",
  cohortIds = c(),
  cohortDefinitionSet = NULL,
  databaseId = NULL
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cohortDatabaseSchema}{Schema name where your cohort table resides. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cohortTable}{The name of the cohort table.}

\item{cohortIds}{The cohort Id(s) used to reference the cohort in the cohort
table. If left empty and no `cohortDefinitionSet` argument is
specified, all cohorts in the table will be included. If
you specify the `cohortIds` AND `cohortDefinitionSet`, the counts will
reflect the `cohortIds` from the `cohortDefinitionSet`.}

\item{cohortDefinitionSet}{The \code{cohortDefinitionSet} argument must be a data frame with 
the following columns: \describe{
\item{cohortId}{The unique integer identifier of the cohort} 
\item{cohortName}{The cohort's name}
\item{sql}{The OHDSI-SQL used to generate the cohort}}
Optionally, this data frame may contain: \describe{
\item{json}{The Circe JSON representation of the cohort}}}

\item{databaseId}{Optional - when specified, the databaseId will be added
to the exported results}
}
\value{
A data frame with cohort counts
}
\description{
Computes the subject and entry count per cohort. Note the cohortDefinitionSet
parameter is optional - if you specify the cohortDefinitionSet, the cohort
counts will be joined to the cohortDefinitionSet to include attributes
like the cohortName.
}
