% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Def_Control_Guess}
\alias{Def_Control_Guess}
\title{Automatically assigns missing guessing control values}
\usage{
Def_Control_Guess(guesses_control, a_n)
}
\arguments{
\item{guesses_control}{list of parameters to control how the guessing works, see Def_Control_Guess() for options or vignette("Control_Options")}

\item{a_n}{list of initial parameter values, used to determine the number of parameters. May be either a list of vectors or a single vector.}
}
\value{
returns a filled list
}
\description{
\code{Def_Control_Guess} checks and assigns default values
}
\examples{
library(data.table)
guesses_control <- list(
  "maxiter" = 10, "guesses" = 10,
  "loglin_min" = -1, "loglin_max" = 1, "loglin_method" = "uniform"
)
a_n <- c(0.1, 2, 1.3)
guesses_control <- Def_Control_Guess(guesses_control, a_n)

}
\seealso{
Other Data Cleaning Functions: 
\code{\link{Check_Dupe_Columns}()},
\code{\link{Check_Trunc}()},
\code{\link{Check_Verbose}()},
\code{\link{Convert_Model_Eq}()},
\code{\link{Correct_Formula_Order}()},
\code{\link{Date_Shift}()},
\code{\link{Def_Control}()},
\code{\link{Def_model_control}()},
\code{\link{Def_modelform_fix}()},
\code{\link{Event_Count_Gen}()},
\code{\link{Event_Time_Gen}()},
\code{\link{Joint_Multiple_Events}()},
\code{\link{Replace_Missing}()},
\code{\link{Time_Since}()},
\code{\link{factorize}()},
\code{\link{factorize_par}()},
\code{\link{gen_time_dep}()},
\code{\link{interact_them}()}
}
\concept{Data Cleaning Functions}
