% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Event_Count_Gen}
\alias{Event_Count_Gen}
\title{uses a table, list of categories, and list of event summaries to generate person-count tables}
\usage{
Event_Count_Gen(table, categ, events, verbose = FALSE)
}
\arguments{
\item{table}{dataframe with every category/event column needed}

\item{categ}{list with category columns and methods, methods can be either strings or lists of boundaries}

\item{events}{list of columns to summarize, supports counts and means and renaming the summary column}

\item{verbose}{integer valued 0-4 controlling what information is printed to the terminal. Each level includes the lower levels. 0: silent, 1: errors printed, 2: warnings printed, 3: notes printed, 4: debug information printed. Errors are situations that stop the regression, warnings are situations that assume default values that the user might not have intended, notes provide information on regression progress, and debug prints out C++ progress and intermediate results. The default level is 2 and True/False is converted to 3/0.}
}
\value{
returns a grouped table and a list of category boundaries used
}
\description{
\code{Event_Count_Gen} generates event-count tables
}
\examples{
library(data.table)
a <- c(0, 1, 2, 3, 4, 5, 6)
b <- c(1, 2, 3, 4, 5, 6, 7)
c <- c(0, 1, 0, 0, 0, 1, 0)
table <- data.table::data.table(
  "a" = a,
  "b" = b,
  "c" = c
)
categ <- list(
  "a" = "0/3/5]7",
  "b" = list(
    lower = c(-1, 3, 6),
    upper = c(3, 6, 10),
    name = c("low", "medium", "high")
  )
)
event <- list(
  "c" = "count AS cases",
  "a" = "mean", "b" = "mean"
)
e <- Event_Count_Gen(table, categ, event, T)

}
\seealso{
Other Data Cleaning Functions: 
\code{\link{Check_Iters}()},
\code{\link{Date_Shift}()},
\code{\link{Event_Time_Gen}()},
\code{\link{Joint_Multiple_Events}()},
\code{\link{Replace_Missing}()},
\code{\link{Time_Since}()},
\code{\link{apply_norm}()},
\code{\link{factorize}()},
\code{\link{gen_time_dep}()}
}
\concept{Data Cleaning Functions}
