% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Countr-package.R
\docType{package}
\name{Countr-package}
\alias{Countr-package}
\alias{Countr}
\title{Flexible Univariate Count Models Based on Renewal Processes}
\description{
Flexible univariate count models based on renewal
processes. The models may include covariates and can be specified
with familiar formula syntax as in glm() and 'flexsurv'.
}
\details{
The methodology is described by
\insertCiteOnly{CountrJssArticle;textual}{Countr}.  The paper is included in
the package as vignette \code{vignette('Countr_guide_paper', package = "Countr")}).

The main function is \code{\link{renewalCount}}, see its documentation for
examples.

Goodness of fit chi-square (likelihood ratio and Pearson) tests for glm and
count renewal models are implemented in \code{\link{chiSq_gof}} and
\code{\link{chiSq_pearson}}.
}
\references{
\insertRef{baker2017event}{Countr}

\insertRef{boshnakov2017bivariate}{Countr}

\insertRef{cameron2013regression}{Countr}

\insertRef{CountrJssArticle}{Countr}

\insertRef{mcshane2008count}{Countr}

\insertRef{winkelmann1995duration}{Countr}
}
