% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.CombinedVoting.R
\name{CombinedVoting}
\alias{CombinedVoting}
\title{Implementation of Combined Voting.}
\description{
Calculates the final prediction by performing the result of the
predictions of different metrics obtained through a \code{\link{SimpleVoting}}
class.
}
\seealso{
\code{\link{D2MCS}}, \code{\link{ClassMajorityVoting}},
\code{\link{ClassWeightedVoting}}, \code{\link{ProbAverageVoting}},
\code{\link{ProbAverageWeightedVoting}}, \code{\link{ProbBasedMethodology}},
\code{\link{SimpleVoting}}
}
\keyword{math}
\keyword{methods}
\keyword{models}
\section{Super class}{
\code{\link[D2MCS:VotingStrategy]{D2MCS::VotingStrategy}} -> \code{CombinedVoting}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CombinedVoting-new}{\code{CombinedVoting$new()}}
\item \href{#method-CombinedVoting-getCombinedMetrics}{\code{CombinedVoting$getCombinedMetrics()}}
\item \href{#method-CombinedVoting-getMethodology}{\code{CombinedVoting$getMethodology()}}
\item \href{#method-CombinedVoting-getFinalPred}{\code{CombinedVoting$getFinalPred()}}
\item \href{#method-CombinedVoting-execute}{\code{CombinedVoting$execute()}}
\item \href{#method-CombinedVoting-clone}{\code{CombinedVoting$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="D2MCS" data-topic="VotingStrategy" data-id="getMetrics"><a href='../../D2MCS/html/VotingStrategy.html#method-VotingStrategy-getMetrics'><code>D2MCS::VotingStrategy$getMetrics()</code></a></span></li>
<li><span class="pkg-link" data-pkg="D2MCS" data-topic="VotingStrategy" data-id="getName"><a href='../../D2MCS/html/VotingStrategy.html#method-VotingStrategy-getName'><code>D2MCS::VotingStrategy$getName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="D2MCS" data-topic="VotingStrategy" data-id="getVotingSchemes"><a href='../../D2MCS/html/VotingStrategy.html#method-VotingStrategy-getVotingSchemes'><code>D2MCS::VotingStrategy$getVotingSchemes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CombinedVoting-new"></a>}}
\if{latex}{\out{\hypertarget{method-CombinedVoting-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CombinedVoting$new(voting.schemes, combined.metrics, methodology, metrics)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{voting.schemes}}{A \link{list} of elements inherited from
\code{\link{SimpleVoting}}.}

\item{\code{combined.metrics}}{An object defining the metrics used to combine
the voting schemes. The object must inherit from
\code{\link{CombinedMetrics}} class.}

\item{\code{methodology}}{An object specifying the methodology used to execute
the combined voting. Object inherited from \code{\link{Methodology}}
object}

\item{\code{metrics}}{A \link{character} vector with the name of the
metrics used to perform the combined voting operations. Metrics should be
previously defined during training stage.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CombinedVoting-getCombinedMetrics"></a>}}
\if{latex}{\out{\hypertarget{method-CombinedVoting-getCombinedMetrics}{}}}
\subsection{Method \code{getCombinedMetrics()}}{
The function returns the metrics used to combine the metrics
results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CombinedVoting$getCombinedMetrics()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object inherited from \code{\link{CombinedMetrics}} class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CombinedVoting-getMethodology"></a>}}
\if{latex}{\out{\hypertarget{method-CombinedVoting-getMethodology}{}}}
\subsection{Method \code{getMethodology()}}{
The function gets the methodology used to execute the
combined votings.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CombinedVoting$getMethodology()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object inherited from \code{\link{Methodology}} class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CombinedVoting-getFinalPred"></a>}}
\if{latex}{\out{\hypertarget{method-CombinedVoting-getFinalPred}{}}}
\subsection{Method \code{getFinalPred()}}{
The function returns the predictions obtained after
executing the combined-voting methodology.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CombinedVoting$getFinalPred(type = NULL, target = NULL, filter = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{A \link{character} to define which type of predictions
should be returned. If not defined all type of probabilities will be
returned. Conversely if "prob" or "raw" is defined then computed
'probabilistic' or 'class' values are returned.}

\item{\code{target}}{A \link{character} defining the value of the
positive class.}

\item{\code{filter}}{A \link{logical} value used to specify if only predictions
matching the target value should be returned or not. If \link{TRUE} the
function returns only the predictions matching the target value.
Conversely if \link{FALSE} (by default) the function returns all the
predictions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{data.frame} with the computed predictions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CombinedVoting-execute"></a>}}
\if{latex}{\out{\hypertarget{method-CombinedVoting-execute}{}}}
\subsection{Method \code{execute()}}{
The function implements the combined voting scheme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CombinedVoting$execute(predictions, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictions}}{A \code{\link{ClusterPredictions}} object containing
the predictions computed for each cluster.}

\item{\code{verbose}}{A \link{logical} value to specify if more verbosity is
needed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CombinedVoting-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CombinedVoting-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CombinedVoting$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
