% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods_DCS.R
\name{summary.dcs}
\alias{summary.dcs}
\title{Summarizing Results from Double Conditional Smoothing}
\usage{
\method{summary}{dcs}(object, ...)
}
\arguments{
\item{object}{an object of class "dcs", usually, a result of a call to 
\code{\link{dcs}}.}

\item{...}{Additional arguments passed to the \code{summary.dcs} function.}
}
\value{
The function \code{summary.dcs} returns an object of class 
 \code{summary_dcs} including \tabular{ll}{
 \code{h_opt} \tab estimated optimal bandwidth from the IPI-procedure. \cr
 \code{c_f} \tab estimated variance factor. \cr
 \code{iterations} \tab number of iterations of the IPI-procedure. \cr
 \code{time_used} \tab time spend searching for optimal bandwidths (not 
  overall runtime of the function). \cr
 \code{var_est} \tab estimated variance model. Has class "sarma" if an
  SARMA model is used and class "sfarima" if an SFARIMA model is used.\cr
 \code{var_model_id} \tab identifier for the variance model estimated. \cr
 \code{var_model_order} \tab order of the estimated variance model, if either
  SARMA or SFARIMA is used. \cr
 \code{dcs_options} \tab an object of class \code{cds_options} containing the
  initial options of the dcs procedure. \cr
}
}
\description{
\code{summary} method for class \code{"dcs"}
}
\section{Details}{

\code{summary.dcs} strips an object of class \code{"dcs"} from all large
 matrices (\code{Y}, \code{X}, \code{T}, \code{M}, \code{R}), allowing
 for easier handling of meta-statistics of the bandwidth selection procedure.

 \code{print.summary_dcs} returns a list of summary statistics
 from the dcs procedure. The output depends on the use of the \code{dcs}-
 function. If automatic bandwidth selection is chosen, \code{summary.dcs}
 prints detailed statistics of the type of regression, the estimated 
 bandwidths \code{h_x}, \code{h_t}, the variance coefficient \code{c_f} and 
 performance statistics such as the number of iterations of the IPI-algorithm 
 and the time used for bandwidth selection.

 The method used for estimation of the variance coefficient is printed and 
 the results of an SARMA/SFARIMA-estimation, if available.

 If bandwidths are supplied to \code{dcs}, \code{summary.dcs} only prints
 the given bandwidths.
}

\examples{
y <- y.norm1 + matrix(rnorm(101^2), nrow = 101, ncol = 101)
dcs_object <- dcs(y)
summary(dcs_object)

}
