% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDeltaParams.R
\name{GetDeltaParams}
\alias{GetDeltaParams}
\alias{print.GetDeltaParams}
\title{Calculate Delta related parameters function}
\usage{
GetDeltaParams(mx, fixedrows = FALSE, Delta, Pi, B, k, Cov)

\method{print}{GetDeltaParams}(x, ...)
}
\arguments{
\item{mx}{Matrix. Agreement contingency table to perform calculations}

\item{fixedrows}{Boolean. Indicate if sample rows are fixed beforehand.}

\item{Delta}{Vector. Each element indicate the probability of recognize an element i.}

\item{Pi}{Vector. Each element indicate the probability of classify at random an element in category i.}

\item{B}{Double. Numerical solution to the equation given by the model.}

\item{k}{Integer. Dimension of the problem.}

\item{Cov}{Matrix. Covariance matrix of Delta.}

\item{x}{List produced by GetDeltaParams}

\item{...}{Other print options}
}
\value{
\code{NULL}
}
\description{
This function perform all needed calculations to get all Delta related parameters. For do the exact calculations some variables previously calculated are needed.
}
\examples{
GetDeltaParams(mx = matrix(c(60,0,3,2,50,1,3,2,79),3,3), 
			Delta = c( 0.8945724, 0.9522836, 0.8962094), 
              Pi = c( 0.2703707, 0.1939561, 0.5356732), B = 17.94867,k = 3, Cov = 
         matrix(c(0.002736490,  0.000004188, -0.001074704,
                0.000004188, 0.001141059, -0.000181746,
               -0.001074704, -0.000181746,  0.004912131),3,3), fixedrows = FALSE)
}
\keyword{B}
\keyword{Cov}
\keyword{Delta}
\keyword{Pi}
\keyword{fixedrows}
\keyword{k}
\keyword{mx}
