% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSCoTEA.R
\name{plotDistOverTime}
\alias{plotDistOverTime}
\title{Plot distribution of treatment effects over time}
\usage{
plotDistOverTime(
  cdf_centered,
  grid_cdf,
  t_start,
  t_max,
  CI,
  ci_lower,
  ci_upper,
  ylim = c(0, 1),
  xlim = NULL,
  cdf = TRUE,
  xlab = "Distribution Difference",
  ylab = "CDF",
  obsLine = NULL,
  savePlots = FALSE,
  plotName = NULL,
  lty = 1,
  lty_obs = 1,
  t_plot = NULL
)
}
\arguments{
\item{cdf_centered}{list of centered distributional statistics}

\item{grid_cdf}{grid}

\item{t_start}{start time}

\item{t_max}{maximum time}

\item{CI}{logical indicating whether to plot confidence intervals}

\item{ci_lower}{lower confidence interval}

\item{ci_upper}{upper confidence interval}

\item{ylim}{y limits}

\item{xlim}{x limits}

\item{cdf}{logical indicating whether to plot CDF or quantile difference}

\item{xlab}{x label}

\item{ylab}{y label}

\item{obsLine}{optional additional line to plot. Default is NULL which means no line is plotted.}

\item{savePlots}{logical indicating whether to save plots}

\item{plotName}{name of plot to save}

\item{lty}{line type for the main line passed as cdf_centered}

\item{lty_obs}{line type for the optional additional line passed as obsLine}

\item{t_plot}{optional vector of times to plot. Default is NULL which means all times are plotted.}
}
\value{
plot of distribution of treatment effects over time
}
\description{
Plot distribution of treatment effects over time
}
\keyword{internal}
