% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{determine_drug_targets}
\alias{determine_drug_targets}
\title{Determine drug target nodes in network}
\usage{
determine_drug_targets(graphs, annotations, drug_target_interactions, settings)
}
\arguments{
\item{graphs}{[list] A named list with elements `groupA` and `groupB` containing the combined graphs
of each group as iGraph object (`graphs` from output of \code{\link[DrDimont]{generate_combined_graphs}})}

\item{annotations}{[list] List of data frames that map node IDs to identifiers. Contains `both`
with unique identifiers across the whole data (output of \code{\link[DrDimont]{generate_combined_graphs}})}

\item{drug_target_interactions}{[list] Named list specifying drug target interactions for drug response
score computation}

\item{settings}{[list] A named list containing pipeline settings. The settings list has to be
initialized by \code{\link[DrDimont]{drdimont_settings}}. Items in the named list can be
adjusted as desired.}
}
\value{
A named list with elements `targets` and `edgelists`.
`targets` is a named list with elements `target_nodes` and `drugs_to_target_nodes`.
`target_nodes` is a data frame with column `node_id` (unique node IDs in the iGraph object
targeted by drugs) and columns `groupA` and `groupB` (bool values specifying whether the
node is contained in the combined graph of the group). Element `drugs_to_target_nodes` contains
a named list mapping drug names to a vector of their target node IDs.
`edgelists` contains elements `groupA` and `groupB` containing each a list of
edges adjacent to drug target nodes.
}
\description{
Finds node IDs of network nodes in `graphs` that are targeted by a drug in
`drug_target_interactions`. Returns list of node ids and list of adjacent edges.
}
\examples{
data(drug_gene_interactions)
data(combined_graphs_example)

example_settings <- drdimont_settings(
                       save_data=FALSE,
                       python_executable="python")

example_drug_target_interactions <- make_drug_target(target_molecules='protein',
                                            interaction_table=drug_gene_interactions,
                                            match_on='gene_name')

drug_target_edges <- determine_drug_targets(
                           graphs=combined_graphs_example$graphs,
                           annotations=combined_graphs_example$annotations,
                           drug_target_interactions=example_drug_target_interactions,
                           settings=example_settings)

}
