% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{individual_graphs_example}
\alias{individual_graphs_example}
\title{Individual graphs}
\format{
A named list with 2 items.
\describe{
  \item{graphs}{A named list with two groups.}
  \describe{
    \item{groupA}{Graphs associated with `groupA`}
    \describe{
    \item{mrna}{Graph}
    \item{protein}{Graph}
    \item{phosphosite}{Graph}
    \item{metabolite}{Graph}
    }
    \item{groupB}{same structure as `groupA`}
    }
  \item{annotations}{A named list containing data frames of mappings of assigned node IDs to the
  user-provided component identifiers for nodes in `groupA` or `groupB` and all nodes}
  \describe{
  \item{groupA}{Annotations associated with `groupA`}
    \describe{
    \item{mrna}{Data frame}
    \item{protein}{Data frame}
    \item{phosphosite}{Data frame}
    \item{metabolite}{Data frame}
    }
  \item{groupB}{same structure as `groupA`}
  \item{both}{same structure as `groupA`}
  }
}
}
\source{
Krug, Karsten et al. “Proteogenomic Landscape of Breast Cancer Tumorigenesis and
Targeted Therapy.” Cell vol. 183,5 (2020): 1436-1456.e31. doi:10.1016/j.cell.2020.10.036
}
\usage{
individual_graphs_example
}
\description{
Exemplary intermediate pipeline output: Individual graphs example data built by
\code{\link[DrDimont]{generate_individual_graphs}}. Graphs were created from
\link[DrDimont]{correlation_matrices_example} and
reduced by the `pickHardThreshold` reduction method. Used settings were:
}
\details{
\code{settings <- drdimont_settings(
                        reduction_method=list(default="pickHardThreshold"),
                        r_squared=list(
                            default=0.8,
                            groupA=list(metabolite=0.45),
                            groupB=list(metabolite=0.15)),
                        cut_vector=list(
                            default=seq(0.3, 0.7, 0.01),
                            metabolite=seq(0.1, 0.65, 0.01)))}

A subset of the original data by Krug et al. (2020) and randomly sampled metabolite
data from \code{\link[DrDimont]{layers_example}} was used to generate the correlation
matrices and individual graphs. They were created from data stratified by estrogen
receptor (ER) status: `groupA` contains data of ER+ patients and `groupB` of
ER- patients.
}
\keyword{datasets}
