% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseLargeScaleCharacteristics.R
\name{summariseLargeScaleCharacteristics}
\alias{summariseLargeScaleCharacteristics}
\title{This function is used to summarise the lasrge scale characteristics of a
cohort table}
\usage{
summariseLargeScaleCharacteristics(
  cohort,
  cdm = attr(cohort, "cdm_reference"),
  strata = list(),
  window = list(c(-Inf, -366), c(-365, -31), c(-30, -1), c(0, 0), c(1, 30), c(31, 365),
    c(366, Inf)),
  tablesToCharacterize = c("condition_occurrence", "drug_era", "procedure_occurrence",
    "measurement"),
  overlap = TRUE,
  minCellCount = 5
)
}
\arguments{
\item{cohort}{cohort}

\item{cdm}{'cdm' object created with CDMConnector::cdm_from_con(). It must
must contain the 'targetCohort' table and all the tables that we want to
characterize. It is a compulsory input, no default value is provided.}

\item{strata}{Stratification list}

\item{window}{Temporal windows that we want to characterize. It must
be a list of numeric vectors of length two. The tables will be characterized
between the first element and the second element respect to the
cohort_start_date of each individual. To refer to any time prior set NA the
first element of the vector. To refer to any time after the index date set NA
the second element of the vector. By default: list(c(NA, -366), c(-365, -90),
c(-365, -31), c(-90, -1), c(-30, -1), c(0, 0), c(1, 30), c(1, 90),
c(31, 365), c(91, 365), c(366, NA)).}

\item{tablesToCharacterize}{Name of the tables in the cdm that we want to
summarize. The available tables to characterize are: "visit_occurrence",
"condition_occurrence", "drug_exposure", "procedure_occurrence",
"device_exposure", "measurement", "observation", "drug_era", "condition_era"
and "specimen". By default: c("condition_occurrence", "drug_era",
"procedure_occurrence", "measurement").}

\item{overlap}{Whether you want to consider overlapping events (overlap =
TRUE) or only incident ones (overlap = FALSE).}

\item{minCellCount}{All counts lower than minimumCellCount will be
obscured changing its value by NA. 'obscured' column of characterization
tibble is TRUE when a count has been obscured. Otherwise it is FALSE.}
}
\value{
The output of this function is a 3 elements list. First
("Characterization") is a reference to a temporal table in the database. It
contains the characterization of the desired cohorts of interest. The cohorts
of interest are specified using 'targetCohortId' and 'targetCohortName'. The
characterized tables are the ones specified in 'tablesToChacaterize'. Second
("temporalWindow") contains the windows used to do the characaterization.
Finally "overlap" is also included in the list.
}
\description{
This function is used to summarise the lasrge scale characteristics of a
cohort table
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

summariseLargeScaleCharacteristics(
  cohort = cdm$cohort1,
  tablesToCharacterize= c("drug_exposure", "condition_occurrence")
)
}

}
