% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/require.R
\name{requireDrugInDateRange}
\alias{requireDrugInDateRange}
\title{Restrict cohort to only cohort records within a certain date range}
\usage{
requireDrugInDateRange(
  cohort,
  dateRange,
  indexDate = "cohort_start_date",
  cohortId = NULL,
  name = omopgenerics::tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{dateRange}{Date interval to consider. Any records with the index date
outside of this range will be dropped.}

\item{indexDate}{The column containing the date that will be checked against
the date range.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{name}{Name of the new cohort table, it must be a length 1 character
vector.}
}
\value{
The cohort table having applied the date requirement.
}
\description{
Filter the cohort table keeping only the cohort records for which the
specified index date is within a specified date range.
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr)

cdm <- mockDrugUtilisation()

cdm$cohort1 <- cdm$cohort1 |>
  requireDrugInDateRange(
    dateRange = as.Date(c("2020-01-01", NA))
  )

attrition(cdm$cohort1) |> glimpse()
}

}
