% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotTreatment}
\alias{plotTreatment}
\title{Generate a custom ggplot2 from a summarised_result object generated with
summariseTreatment function.}
\usage{
plotTreatment(
  result,
  facet = cdm_name + cohort_name ~ window_name,
  colour = "variable_level"
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}
}
\value{
A ggplot2 object.
}
\description{
Generate a custom ggplot2 from a summarised_result object generated with
summariseTreatment function.
}
\examples{
\dontrun{
cdm <- mockDrugUtilisation()
result <- cdm$cohort1 |>
  summariseTreatment(
    treatmentCohortName = "cohort2",
    window = list(c(0, 30), c(31, 365))
  )

plotTreatment(result)
}

}
