% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEAaq_export.R
\name{EEAaq_export}
\alias{EEAaq_export}
\title{Export and save an \code{EEAaq_df} class object}
\usage{
EEAaq_export(data, filepath, format)
}
\arguments{
\item{data}{an \code{EEAaq_df} class object.}

\item{filepath}{character string giving the file path}

\item{format}{character string giving the format of the file. It must be one of 'csv' and 'txt'.}
}
\value{
No return value, called for side effects.
}
\description{
\code{EEAaq_export} export an \code{EEAaq_df} class object as a \emph{.csv} or a \emph{.txt} file.
}
\examples{
\donttest{
### Download PM10 data for the province (NUTS-3) of Milano (Italy)
### from January 1st to January 31st, 2023
`\%>\%` <- dplyr::`\%>\%`
IDstations <- EEAaq_get_stations(byStation = TRUE, complete = FALSE)
IDstations <- IDstations \%>\%
                dplyr::filter(NUTS3 \%in\% c("Milano")) \%>\%
                dplyr::pull(AirQualityStationEoICode) \%>\%
                unique()
data <- EEAaq_get_data(IDstations = IDstations, pollutants = "PM10",
                       from = "2023-01-01", to = "2023-01-31",
                       verbose = TRUE)

### Export data to csv file
temp <- tempdir()
filepath <- paste0(temp, "/data.csv")
EEAaq_export(data = data, filepath = filepath, format = "csv")
}
}
