% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEAaq_get_data.R
\name{EEAaq_get_data}
\alias{EEAaq_get_data}
\title{Download air quality data at european level from the EEA download service}
\usage{
EEAaq_get_data(
  IDstations = NULL,
  pollutants = NULL,
  from = NULL,
  to = NULL,
  verbose = TRUE
)
}
\arguments{
\item{IDstations}{Numeric value. Unique ID of the stations to retrieve.}

\item{pollutants}{the pollutants for which to download data. It may be:
\itemize{
\item{character vector representing the short names of the pollutants to analyse. The reference is the
variable \code{Notation} in the dataset \code{pollutants} provided by this package.}
\item{numeric vector representing the codes of the pollutants to analyse. The reference is the variable \code{Code}
in the dataset \code{pollutants} provided by this package.}
}}

\item{from}{character defining the initial date of the period to be retrieved. The format is \code{yyyy-mm-dd}.}

\item{to}{character defining the final date of the period to be retrieved. The format is \code{yyyy-mm-dd}.}

\item{verbose}{logic value (T or F). If \code{TRUE} (the default) information about the function progress are printed.
If \code{FALSE} no message is printed.}
}
\value{
A data frame of class \code{EEAaq_df}, if \code{zone_name} is specified, and of class \code{EEAaq_df_sfc}
if whether the parameter \code{quadrant} or \code{polygon} is specified.
}
\description{
This function retrieves air quality datasets at european level, based on station, time and pollutant specifications.
This function generates a \code{data.frame/tibble} object of class \code{EEAaq_df}.
}
\details{
Recall that stations and sensors are physically managed by national or local environmental protection agencies with their own specificities and rules.
EEA operates as a collector of national environmental protection systems and harmonizes the information received by national offices.
However, data provided can change on a country basis. For instance, time resolution, sampling frequency, spatial coverage, or
the classifications (e.g., urban or rural) can differ country by country. Before downloading the data, we suggest to manage and filter the stations/sensors
of interest through their metadata files (provided by \code{EEAaq_get_stations} or \code{EEAaq_get_dataframe}). See the examples and the vignette
for practical examples.
}
\examples{
\donttest{
`\%>\%` <- dplyr::`\%>\%`
### Download PM10 data for the province (NUTS-3) of Milano (Italy)
### from January 1st to January 31st, 2023
IDstations <- EEAaq_get_stations(byStation = TRUE, complete = FALSE)
IDstations <- IDstations \%>\%
                dplyr::filter(NUTS3 \%in\% c("Milano")) \%>\%
                dplyr::pull(AirQualityStationEoICode) \%>\%
                unique()
data <- EEAaq_get_data(IDstations = IDstations, pollutants = "PM10",
                       from = "2023-01-01", to = "2023-01-31",
                       verbose = TRUE)
}
}
