% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend.R
\name{make_trend}
\alias{make_trend}
\title{Create a trend specification for model parameters}
\usage{
make_trend(
  par_names,
  cov_names,
  kernels,
  bases = NULL,
  shared = NULL,
  trend_pnames = NULL,
  premap = TRUE,
  pretransform = FALSE
)
}
\arguments{
\item{par_names}{Character vector specifying which parameters to apply trend to}

\item{cov_names}{Character vector specifying which covariates to use for each trend}

\item{kernels}{Character vector specifying which kernel function to use for each trend}

\item{bases}{Optional character vector specifying which base function to use for each trend}

\item{shared}{Named list with entries the parameter names to be shared and the names the new names of the shared parameter.}

\item{trend_pnames}{Optional character vector specifying custom parameter names}

\item{premap}{Logical indicating if trend should be applied before or after parameter mapping}

\item{pretransform}{If !premap, logical indicating if trend should be applied before or after parameter transformation}
}
\value{
A list containing the trend specifications for each parameter
}
\description{
Create a trend specification for model parameters
}
\examples{
# Put trend on B and v parameters
trend <- make_trend(
  par_names = c("B", "v"),
  cov_names = "strial",
  kernels = c("exp_incr", "poly3"),
  premap = TRUE,
  shared = list(shrd = list("B.B0", "v.d1"))
)
get_trend_pnames(trend)

}
