% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust.scores.R
\name{robust.scores}
\alias{robust.scores}
\title{Extract robust end-member scores.}
\usage{
robust.scores(loadings, l, mc_n, cores = 1, plot = FALSE, ...)
}
\arguments{
\item{loadings}{\code{List} of class \code{"EMMAgeo_robload"}, i.e. the 
outout of \code{robust.loadings()}, containing statistic descriptions of 
robust end-member loadings.}

\item{l}{\code{Numeric} scalar, weight transformation limit to use for 
modelling the average end-member output. Can be output of 
\code{get.l.opt()}. If omitted, it is set to \code{0}.}

\item{mc_n}{\code{Numeric} scalar, number of Monte Carlo simulations to 
estimate end-member scores uncertainty. The default setting is ten times the 
product of number of end-members and number of weight transformation limits. 
The latter is inherited from \code{model.em()}. To disable modelling of 
scores uncertainty, set \code{mc_n = 0}.}

\item{cores}{\code{Numeric} scalar, number of CPU cores to be used for 
calculations. Only useful in multicore architectures. Default is \code{1} 
(single core).}

\item{plot}{\code{Logical} scalar, option for plot output. Default is 
\code{FALSE}.}

\item{\dots}{Additional arguments passed to \code{EMMA} and \code{plot}.}
}
\value{
\code{List} with statistic descriptions of robust end-member 
scores.
}
\description{
This function takes a list object with statistics of end-member loadings and 
propagates these uncertainties to end-member scores using Monte Carlo 
methods.
}
\examples{

## load example data set, potential end-members, output of model.EM()
data(example_EMpot)

## define limits for robust end-members
limits <- cbind(c(61, 74, 95, 102), 
                c(64, 76, 100, 105))

## get robust end-member loadings
robust_loadings <- robust.loadings(em = EMpot, limits = limits)

## model end-member scores uncertainties with minimum Monte Carlo runs
robust_scores <- robust.scores(loadings = robust_loadings, 
                               mc_n = 5, 
                               plot = TRUE)
                    
}
\seealso{
\code{\link{robust.EM}}, \code{\link{robust.loadings}}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
