% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_kernel}
\alias{Eigen_kernel}
\title{Kernel of a matrix}
\usage{
Eigen_kernel(M, method = "COD")
}
\arguments{
\item{M}{a matrix, real or complex}

\item{method}{one of \code{"COD"} or \code{"LU"}; the faster method depends 
on the size of the matrix}
}
\value{
A basis of the kernel of \code{M}. With \code{method = "COD"}, the 
  basis is orthonormal, while it is not with \code{method = "LU"}.
}
\description{
Kernel (null-space) of a real or complex matrix.
}
\examples{
set.seed(666)
M <- matrix(rgamma(30L, 12, 1), 10L, 3L)
M <- cbind(M, M[,1]+M[,2], M[,2]+2*M[,3])
# basis of the kernel of `M`:
Eigen_kernel(M, method = "LU")
# orthonormal basis of the kernel of `M`:
Eigen_kernel(M, method = "COD")
}
\seealso{
\code{\link{Eigen_kernelDimension}}.
}
