/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.mcmc;

import dr.inference.loggers.Loggable;
import dr.inference.model.Bounds;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.OperatorSchedule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface Analysis {
    public Likelihood getJoint();

    public OperatorSchedule getSchedule();

    public List<Loggable> getLoggerColumns();

    public static Parameter makeParameter(String name, int dim) {
        Parameter.Default param = new Parameter.Default(name, dim, 0.0);
        double[] uppers = new double[dim];
        double[] lowers = new double[dim];
        Arrays.fill(uppers, Double.POSITIVE_INFINITY);
        Arrays.fill(lowers, Double.NEGATIVE_INFINITY);
        param.addBounds((Bounds)new Parameter.DefaultBounds(uppers, lowers));
        return param;
    }

    public static abstract class Base
    implements Analysis {
        protected Likelihood likelihood;
        protected Likelihood prior;
        protected Likelihood joint;
        protected OperatorSchedule schedule;
        protected Parameter beta;

        @Override
        public List<Loggable> getLoggerColumns() {
            this.likelihood.setId("likelihood");
            this.prior.setId("prior");
            ArrayList<Loggable> columns = new ArrayList<Loggable>();
            columns.add((Loggable)this.likelihood);
            columns.add((Loggable)this.prior);
            columns.add((Loggable)this.beta);
            return columns;
        }

        @Override
        public Likelihood getJoint() {
            return this.joint;
        }

        @Override
        public OperatorSchedule getSchedule() {
            return this.schedule;
        }
    }
}

