% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LikelihoodApproximation.R
\name{skewNormal}
\alias{skewNormal}
\title{The skew normal function to approximate a log likelihood function}
\usage{
skewNormal(x, mu, sigma, alpha)
}
\arguments{
\item{x}{The log(hazard ratio) for which to approximate the log likelihood.}

\item{mu}{The position parameter.}

\item{sigma}{The scale parameter.}

\item{alpha}{The skew parameter.}
}
\value{
The approximate log likelihood for the given x.
}
\description{
The skew normal function to approximate a log likelihood function
}
\details{
The skew normal function. When \code{alpha = 0} this function is the normal distribution.
}
\examples{
skewNormal(x = 0:3, mu = 0, sigma = 1, alpha = 0)

}
\references{
Azzalini, A. (2013). The Skew-Normal and Related Families. Institute of Mathematical Statistics
Monographs. Cambridge University Press.
}
