% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedirt_gpcm_data.R
\name{fedirt_gpcm_data}
\alias{fedirt_gpcm_data}
\title{Federated gpcm model}
\usage{
fedirt_gpcm_data(inputdata)
}
\arguments{
\item{inputdata}{A List of all responding matrix.}
}
\value{
A list with the estimated global discrimination a, global difficulty b, person's abilities ability, sites' abilities site, and log-likelihood value loglik.
}
\description{
This function is only used to test the accuracy and processing time of this algorithm. It inputs a list of responding matrices and return the federated gpcm parameters.
Note: This function can only calculate one combined dataset. To use federated gpcm in distributed datasets, please use fedirt_gpcm().
}
\details{
Input is a List of responding matrices from each school, every responding matrix is one site's data.
}
\examples{
\donttest{
inputdata = list(as.matrix(example_data_graded))
fedresult = fedirt_gpcm_data(inputdata)

inputdata = list(as.matrix(example_data_graded_and_binary))
fedresult = fedirt_gpcm_data(inputdata)
}
}
